/*
 * Decompiled with CFR 0.152.
 */
package git4idea.push;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.push.PushSource;
import com.intellij.dvcs.push.PushSpec;
import com.intellij.dvcs.push.PushTarget;
import com.intellij.dvcs.repo.Repository;
import com.intellij.history.Label;
import com.intellij.history.LocalHistory;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.update.UpdatedFiles;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import git4idea.DialogManager;
import git4idea.GitLocalBranch;
import git4idea.GitPlatformFacade;
import git4idea.GitRemoteBranch;
import git4idea.GitRevisionNumber;
import git4idea.branch.GitBranchUtil;
import git4idea.commands.Git;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandlerListener;
import git4idea.commands.GitStandardProgressAnalyzer;
import git4idea.config.GitVcsSettings;
import git4idea.config.UpdateMethod;
import git4idea.history.GitHistoryUtils;
import git4idea.merge.MergeChangeCollector;
import git4idea.push.GitPushNativeResult;
import git4idea.push.GitPushNativeResultParser;
import git4idea.push.GitPushRepoResult;
import git4idea.push.GitPushResult;
import git4idea.push.GitPushSource;
import git4idea.push.GitPushSupport;
import git4idea.push.GitPushTagMode;
import git4idea.push.GitPushTarget;
import git4idea.push.GitRejectedPushUpdateDialog;
import git4idea.push.GroupedPushResult;
import git4idea.push.PushUpdateSettings;
import git4idea.repo.GitBranchTrackInfo;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.update.GitRebaseOverMergeProblem;
import git4idea.update.GitUpdateProcess;
import git4idea.update.GitUpdateResult;
import git4idea.update.GitUpdater;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class GitPushOperation {
    private static final Logger LOG = Logger.getInstance(GitPushOperation.class);
    private static final int MAX_PUSH_ATTEMPTS = 10;
    private final Project myProject;
    private final GitPushSupport myPushSupport;
    private final Map<GitRepository, PushSpec<GitPushSource, GitPushTarget>> myPushSpecs;
    private final GitPushTagMode myTagMode;
    private final boolean myForce;
    private final Git myGit;
    private final ProgressIndicator myProgressIndicator;
    private final GitVcsSettings mySettings;
    private final GitPlatformFacade myPlatformFacade;
    private final GitRepositoryManager myRepositoryManager;

    public GitPushOperation(Project project, GitPushSupport pushSupport, Map<GitRepository, PushSpec<GitPushSource, GitPushTarget>> pushSpecs, GitPushTagMode tagMode, boolean force) {
        this.myProject = project;
        this.myPushSupport = pushSupport;
        this.myPushSpecs = pushSpecs;
        this.myTagMode = tagMode;
        this.myForce = force;
        this.myGit = (Git)ServiceManager.getService(Git.class);
        this.myProgressIndicator = (ProgressIndicator)ObjectUtils.notNull((Object)ProgressManager.getInstance().getProgressIndicator(), (Object)new EmptyProgressIndicator());
        this.mySettings = GitVcsSettings.getInstance(this.myProject);
        this.myPlatformFacade = (GitPlatformFacade)ServiceManager.getService((Project)project, GitPlatformFacade.class);
        this.myRepositoryManager = (GitRepositoryManager)((Object)ServiceManager.getService((Project)this.myProject, GitRepositoryManager.class));
        HashMap currentHeads = ContainerUtil.newHashMap();
        for (GitRepository repository : pushSpecs.keySet()) {
            repository.update();
            String head = repository.getCurrentRevision();
            if (head == null) {
                LOG.error("This repository has no commits");
                continue;
            }
            currentHeads.put(repository, new GitRevisionNumber(head));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GitPushResult execute() {
        PushUpdateSettings updateSettings = this.readPushUpdateSettings();
        Label beforePushLabel = null;
        Label afterPushLabel = null;
        Map<GitRepository, String> preUpdatePositions = this.updateRootInfoAndRememberPositions();
        Boolean rebaseOverMergeProblemDetected = null;
        HashMap results = ContainerUtil.newHashMap();
        HashMap updatedRoots = ContainerUtil.newHashMap();
        try {
            Collection<GitRepository> remainingRoots = this.myPushSpecs.keySet();
            for (int pushAttempt = 0; pushAttempt < 10 && !remainingRoots.isEmpty(); ++pushAttempt) {
                Map<GitRepository, GitPushRepoResult> resultMap = this.push(remainingRoots);
                results.putAll(resultMap);
                GroupedPushResult result = GroupedPushResult.group(resultMap);
                if (!result.errors.isEmpty()) {
                    break;
                }
                if (!result.rejected.isEmpty()) {
                    boolean shouldUpdate = true;
                    if (this.myForce || GitPushOperation.pushingToNotTrackedBranch(result.rejected)) {
                        shouldUpdate = false;
                    } else if (pushAttempt == 0 && !this.mySettings.autoUpdateIfPushRejected()) {
                        rebaseOverMergeProblemDetected = !this.findRootsWithMergeCommits(this.getRootsToUpdate(updateSettings, result.rejected.keySet())).isEmpty();
                        updateSettings = this.showDialogAndGetExitCode(result.rejected.keySet(), updateSettings, rebaseOverMergeProblemDetected);
                        if (updateSettings != null) {
                            this.savePushUpdateSettings(updateSettings, rebaseOverMergeProblemDetected);
                        } else {
                            shouldUpdate = false;
                        }
                    }
                    if (!shouldUpdate) {
                        break;
                    }
                    if (beforePushLabel == null) {
                        beforePushLabel = LocalHistory.getInstance().putSystemLabel(this.myProject, "Before push");
                    }
                    Collection<GitRepository> rootsToUpdate = this.getRootsToUpdate(updateSettings, result.rejected.keySet());
                    GitUpdateResult updateResult = this.update(rootsToUpdate, updateSettings.getUpdateMethod(), rebaseOverMergeProblemDetected == null);
                    for (GitRepository repository : rootsToUpdate) {
                        updatedRoots.put(repository, updateResult);
                    }
                    if (!updateResult.isSuccess() || updateResult == GitUpdateResult.SUCCESS_WITH_RESOLVED_CONFLICTS) break;
                    if (updateResult == GitUpdateResult.INCOMPLETE) {
                        break;
                    }
                }
                remainingRoots = GitPushOperation.getRejectedAndNotPushed(results);
            }
        }
        finally {
            if (beforePushLabel != null) {
                afterPushLabel = LocalHistory.getInstance().putSystemLabel(this.myProject, "After push");
            }
            for (GitRepository repository : this.myPushSpecs.keySet()) {
                repository.update();
            }
        }
        return this.prepareCombinedResult(results, updatedRoots, preUpdatePositions, beforePushLabel, afterPushLabel);
    }

    private Collection<GitRepository> getRootsToUpdate(PushUpdateSettings updateSettings, Set<GitRepository> rejectedRepositories) {
        return updateSettings.shouldUpdateAllRoots() ? this.myRepositoryManager.getRepositories() : rejectedRepositories;
    }

    private Collection<VirtualFile> findRootsWithMergeCommits(Collection<GitRepository> rootsToSearch) {
        return ContainerUtil.mapNotNull(rootsToSearch, (Function)new Function<GitRepository, VirtualFile>(){

            public VirtualFile fun(GitRepository repo) {
                PushSpec pushSpec = (PushSpec)GitPushOperation.this.myPushSpecs.get(repo);
                if (pushSpec == null) {
                    GitPushSource source = GitPushOperation.this.myPushSupport.getSource(repo);
                    GitPushTarget target = GitPushOperation.this.myPushSupport.getDefaultTarget(repo);
                    if (target == null) {
                        return null;
                    }
                    pushSpec = new PushSpec((PushSource)source, (PushTarget)target);
                }
                String baseRef = ((GitPushTarget)pushSpec.getTarget()).getBranch().getFullName();
                String currentRef = ((GitPushSource)pushSpec.getSource()).getBranch().getFullName();
                return GitRebaseOverMergeProblem.hasProblem(GitPushOperation.this.myProject, repo.getRoot(), baseRef, currentRef) ? repo.getRoot() : null;
            }
        });
    }

    private static boolean pushingToNotTrackedBranch(Map<GitRepository, GitPushRepoResult> rejected) {
        return ContainerUtil.exists(rejected.entrySet(), (Condition)new Condition<Map.Entry<GitRepository, GitPushRepoResult>>(){

            public boolean value(Map.Entry<GitRepository, GitPushRepoResult> entry) {
                GitRepository repository = entry.getKey();
                GitLocalBranch currentBranch = repository.getCurrentBranch();
                assert (currentBranch != null);
                GitBranchTrackInfo trackInfo = GitBranchUtil.getTrackInfoForBranch(repository, currentBranch);
                return trackInfo == null || !trackInfo.getRemoteBranch().getFullName().equals(entry.getValue().getTargetBranch());
            }
        });
    }

    private static List<GitRepository> getRejectedAndNotPushed(final Map<GitRepository, GitPushRepoResult> results) {
        return ContainerUtil.filter(results.keySet(), (Condition)new Condition<GitRepository>(){

            public boolean value(GitRepository repository) {
                return ((GitPushRepoResult)results.get(repository)).getType() == GitPushRepoResult.Type.REJECTED || ((GitPushRepoResult)results.get(repository)).getType() == GitPushRepoResult.Type.NOT_PUSHED;
            }
        });
    }

    private Map<GitRepository, String> updateRootInfoAndRememberPositions() {
        return ContainerUtil.map2Map(this.myPushSpecs.keySet(), (Function)new Function<GitRepository, Pair<GitRepository, String>>(){

            public Pair<GitRepository, String> fun(GitRepository repository) {
                repository.update();
                return Pair.create((Object)repository, (Object)repository.getCurrentRevision());
            }
        });
    }

    private GitPushResult prepareCombinedResult(Map<GitRepository, GitPushRepoResult> allRoots, Map<GitRepository, GitUpdateResult> updatedRoots, Map<GitRepository, String> preUpdatePositions, Label beforeUpdateLabel, Label afterUpdateLabel) {
        HashMap results = ContainerUtil.newHashMap();
        UpdatedFiles updatedFiles = UpdatedFiles.create();
        for (Map.Entry<GitRepository, GitPushRepoResult> entry : allRoots.entrySet()) {
            GitRepository repository = entry.getKey();
            GitPushRepoResult simpleResult = entry.getValue();
            GitUpdateResult updateResult = updatedRoots.get(repository);
            if (updateResult == null) {
                results.put(repository, simpleResult);
                continue;
            }
            this.collectUpdatedFiles(updatedFiles, repository, preUpdatePositions.get(repository));
            results.put(repository, GitPushRepoResult.addUpdateResult(simpleResult, updateResult));
        }
        return new GitPushResult(results, updatedFiles, beforeUpdateLabel, afterUpdateLabel);
    }

    private Map<GitRepository, GitPushRepoResult> push(Collection<GitRepository> repositories) {
        PushSpec<GitPushSource, GitPushTarget> spec;
        LinkedHashMap results = ContainerUtil.newLinkedHashMap();
        for (GitRepository repository : repositories) {
            GitPushRepoResult repoResult;
            spec = this.myPushSpecs.get(repository);
            ResultWithOutput resultWithOutput = this.doPush(repository, spec);
            LOG.debug("Pushed to " + DvcsUtil.getShortRepositoryName((Repository)repository) + ": " + resultWithOutput);
            GitLocalBranch source = ((GitPushSource)spec.getSource()).getBranch();
            GitPushTarget target = (GitPushTarget)spec.getTarget();
            if (resultWithOutput.isError()) {
                repoResult = GitPushRepoResult.error(source, target.getBranch(), resultWithOutput.getErrorAsString());
            } else {
                List result = resultWithOutput.parsedResults;
                final GitPushNativeResult branchResult = GitPushOperation.getBranchResult(result);
                if (branchResult == null) {
                    LOG.error("No result for branch among: [" + result + "]\n" + "Full result: " + resultWithOutput);
                    continue;
                }
                List tagResults = ContainerUtil.filter((Collection)result, (Condition)new Condition<GitPushNativeResult>(){

                    public boolean value(GitPushNativeResult result) {
                        return !result.equals(branchResult) && (result.getType() == GitPushNativeResult.Type.NEW_REF || result.getType() == GitPushNativeResult.Type.FORCED_UPDATE);
                    }
                });
                int commits = this.collectNumberOfPushedCommits(repository.getRoot(), branchResult);
                repoResult = GitPushRepoResult.convertFromNative(branchResult, tagResults, commits, source, target.getBranch());
            }
            LOG.debug("Converted result: " + repoResult);
            results.put(repository, repoResult);
        }
        for (GitRepository repository : repositories) {
            if (results.containsKey(repository)) continue;
            spec = this.myPushSpecs.get(repository);
            results.put(repository, GitPushRepoResult.notPushed(((GitPushSource)spec.getSource()).getBranch(), ((GitPushTarget)spec.getTarget()).getBranch()));
        }
        return results;
    }

    private static GitPushNativeResult getBranchResult(List<GitPushNativeResult> results) {
        return (GitPushNativeResult)ContainerUtil.find(results, (Condition)new Condition<GitPushNativeResult>(){

            public boolean value(GitPushNativeResult result) {
                return result.getSourceRef().startsWith("refs/heads/");
            }
        });
    }

    private int collectNumberOfPushedCommits(VirtualFile root, GitPushNativeResult result) {
        if (result.getType() != GitPushNativeResult.Type.SUCCESS) {
            return -1;
        }
        String range = result.getRange();
        if (range == null) {
            LOG.error("Range of pushed commits not reported in " + result);
            return -1;
        }
        try {
            return GitHistoryUtils.history(this.myProject, root, range).size();
        }
        catch (VcsException e) {
            LOG.error("Couldn't collect commits from range " + range);
            return -1;
        }
    }

    private void collectUpdatedFiles(UpdatedFiles updatedFiles, GitRepository repository, String preUpdatePosition) {
        MergeChangeCollector collector = new MergeChangeCollector(this.myProject, repository.getRoot(), new GitRevisionNumber(preUpdatePosition));
        ArrayList<VcsException> exceptions = new ArrayList<VcsException>();
        collector.collect(updatedFiles, exceptions);
        for (VcsException exception : exceptions) {
            LOG.info((Throwable)exception);
        }
    }

    private ResultWithOutput doPush(GitRepository repository, PushSpec<GitPushSource, GitPushTarget> pushSpec) {
        GitPushTarget target = (GitPushTarget)pushSpec.getTarget();
        GitLocalBranch sourceBranch = ((GitPushSource)pushSpec.getSource()).getBranch();
        GitRemoteBranch targetBranch = target.getBranch();
        GitLineHandlerListener progressListener = GitStandardProgressAnalyzer.createListener(this.myProgressIndicator);
        boolean setUpstream = ((GitPushTarget)pushSpec.getTarget()).isNewBranchCreated() && !GitPushOperation.branchTrackingInfoIsSet(repository, sourceBranch);
        String tagMode = this.myTagMode == null ? null : this.myTagMode.getArgument();
        GitCommandResult res = this.myGit.push(repository, sourceBranch, targetBranch, this.myForce, setUpstream, tagMode, progressListener);
        return new ResultWithOutput(res);
    }

    private static boolean branchTrackingInfoIsSet(GitRepository repository, final GitLocalBranch source) {
        return ContainerUtil.exists(repository.getBranchTrackInfos(), (Condition)new Condition<GitBranchTrackInfo>(){

            public boolean value(GitBranchTrackInfo info) {
                return info.getLocalBranch().equals(source);
            }
        });
    }

    private void savePushUpdateSettings(PushUpdateSettings settings, boolean rebaseOverMergeDetected) {
        UpdateMethod updateMethod = settings.getUpdateMethod();
        this.mySettings.setUpdateAllRootsIfPushRejected(settings.shouldUpdateAllRoots());
        if (!rebaseOverMergeDetected && this.mySettings.getUpdateType() != updateMethod && this.mySettings.getUpdateType() != UpdateMethod.BRANCH_DEFAULT) {
            this.mySettings.setUpdateType(updateMethod);
        }
    }

    private PushUpdateSettings readPushUpdateSettings() {
        boolean updateAllRoots = this.mySettings.shouldUpdateAllRootsIfPushRejected();
        UpdateMethod updateMethod = this.mySettings.getUpdateType();
        if (updateMethod == UpdateMethod.BRANCH_DEFAULT) {
            updateMethod = GitUpdater.resolveUpdateMethod(this.myProject, this.myPushSpecs.keySet().iterator().next().getRoot());
        }
        return new PushUpdateSettings(updateAllRoots, updateMethod);
    }

    private PushUpdateSettings showDialogAndGetExitCode(final Set<GitRepository> repositories, final PushUpdateSettings initialSettings, final boolean rebaseOverMergeProblemDetected) {
        final Ref updateSettings = Ref.create();
        UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                GitRejectedPushUpdateDialog dialog = new GitRejectedPushUpdateDialog(GitPushOperation.this.myProject, repositories, initialSettings, rebaseOverMergeProblemDetected);
                DialogManager.show(dialog);
                int exitCode = dialog.getExitCode();
                if (exitCode != 1) {
                    GitPushOperation.this.mySettings.setAutoUpdateIfPushRejected(dialog.shouldAutoUpdateInFuture());
                    updateSettings.set((Object)new PushUpdateSettings(dialog.shouldUpdateAll(), GitPushOperation.convertUpdateMethodFromDialogExitCode(exitCode)));
                }
            }
        });
        return (PushUpdateSettings)updateSettings.get();
    }

    private static UpdateMethod convertUpdateMethodFromDialogExitCode(int exitCode) {
        switch (exitCode) {
            case 2: {
                return UpdateMethod.MERGE;
            }
            case 3: {
                return UpdateMethod.REBASE;
            }
        }
        throw new IllegalStateException("Unexpected exit code: " + exitCode);
    }

    protected GitUpdateResult update(Collection<GitRepository> rootsToUpdate, UpdateMethod updateMethod, boolean checkForRebaseOverMergeProblem) {
        GitUpdateResult updateResult = new GitUpdateProcess(this.myProject, this.myPlatformFacade, this.myProgressIndicator, new HashSet<GitRepository>(rootsToUpdate), UpdatedFiles.create(), checkForRebaseOverMergeProblem).update(updateMethod);
        for (GitRepository repository : rootsToUpdate) {
            repository.getRoot().refresh(true, true);
            repository.update();
        }
        return updateResult;
    }

    private static class ResultWithOutput {
        private final List<GitPushNativeResult> parsedResults;
        private final GitCommandResult resultOutput;

        ResultWithOutput(GitCommandResult resultOutput) {
            this.resultOutput = resultOutput;
            this.parsedResults = GitPushNativeResultParser.parse(resultOutput.getOutput());
        }

        boolean isError() {
            return this.parsedResults.isEmpty();
        }

        String getErrorAsString() {
            return this.resultOutput.getErrorOutputAsJoinedString();
        }

        public String toString() {
            return "Parsed results: " + this.parsedResults + "\nCommand output:" + this.resultOutput;
        }
    }
}

