/*
 * Decompiled with CFR 0.152.
 */
package git4idea.push;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.push.PushSource;
import git4idea.GitLocalBranch;

abstract class GitPushSource
implements PushSource {
    GitPushSource() {
    }

    static GitPushSource create(GitLocalBranch branch) {
        return new OnBranch(branch);
    }

    static GitPushSource create(String revision) {
        return new DetachedHead(revision);
    }

    abstract GitLocalBranch getBranch();

    private static class DetachedHead
    extends GitPushSource {
        private final String myRevision;

        public DetachedHead(String revision) {
            this.myRevision = revision;
        }

        public String getPresentation() {
            return DvcsUtil.getShortHash((String)this.myRevision);
        }

        @Override
        GitLocalBranch getBranch() {
            throw new IllegalStateException("Push is not allowed from detached HEAD");
        }
    }

    private static class OnBranch
    extends GitPushSource {
        private final GitLocalBranch myBranch;

        private OnBranch(GitLocalBranch branch) {
            this.myBranch = branch;
        }

        public String getPresentation() {
            return this.myBranch.getName();
        }

        @Override
        GitLocalBranch getBranch() {
            return this.myBranch;
        }
    }
}

