/*
 * Decompiled with CFR 0.152.
 */
package git4idea.push;

import com.intellij.dvcs.push.OutgoingCommitsProvider;
import com.intellij.dvcs.push.PushSettings;
import com.intellij.dvcs.push.PushSupport;
import com.intellij.dvcs.push.PushTargetPanel;
import com.intellij.dvcs.push.Pusher;
import com.intellij.dvcs.push.VcsPushOptionsPanel;
import com.intellij.dvcs.repo.RepositoryManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import git4idea.GitBranch;
import git4idea.GitLocalBranch;
import git4idea.GitRemoteBranch;
import git4idea.GitStandardRemoteBranch;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.branch.GitBranchUtil;
import git4idea.config.GitSharedSettings;
import git4idea.config.GitVcsSettings;
import git4idea.config.GitVersionSpecialty;
import git4idea.push.GitOutgoingCommitsProvider;
import git4idea.push.GitPushSource;
import git4idea.push.GitPushTagPanel;
import git4idea.push.GitPushTarget;
import git4idea.push.GitPushTargetPanel;
import git4idea.push.GitPusher;
import git4idea.repo.GitBranchTrackInfo;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import java.util.Collection;

public class GitPushSupport
extends PushSupport<GitRepository, GitPushSource, GitPushTarget> {
    private final GitRepositoryManager myRepositoryManager;
    private final GitVcs myVcs;
    private final Pusher<GitRepository, GitPushSource, GitPushTarget> myPusher;
    private final OutgoingCommitsProvider<GitRepository, GitPushSource, GitPushTarget> myOutgoingCommitsProvider;
    private final GitVcsSettings mySettings;
    private final GitSharedSettings mySharedSettings;
    private final PushSettings myCommonPushSettings;

    private GitPushSupport(Project project, GitRepositoryManager repositoryManager) {
        this.myRepositoryManager = repositoryManager;
        this.myVcs = (GitVcs)((Object)ObjectUtils.assertNotNull((Object)((Object)GitVcs.getInstance(project))));
        this.mySettings = GitVcsSettings.getInstance(project);
        this.myPusher = new GitPusher(project, this.mySettings, this);
        this.myOutgoingCommitsProvider = new GitOutgoingCommitsProvider(project);
        this.mySharedSettings = (GitSharedSettings)ServiceManager.getService((Project)project, GitSharedSettings.class);
        this.myCommonPushSettings = (PushSettings)ServiceManager.getService((Project)project, PushSettings.class);
    }

    public AbstractVcs getVcs() {
        return this.myVcs;
    }

    public Pusher<GitRepository, GitPushSource, GitPushTarget> getPusher() {
        return this.myPusher;
    }

    public OutgoingCommitsProvider<GitRepository, GitPushSource, GitPushTarget> getOutgoingCommitsProvider() {
        return this.myOutgoingCommitsProvider;
    }

    public GitPushTarget getDefaultTarget(GitRepository repository) {
        if (repository.isFresh()) {
            return null;
        }
        GitLocalBranch currentBranch = repository.getCurrentBranch();
        if (currentBranch == null) {
            return null;
        }
        GitPushTarget persistedTarget = this.getPersistedTarget(repository, currentBranch);
        if (persistedTarget != null) {
            return persistedTarget;
        }
        GitBranchTrackInfo trackInfo = GitBranchUtil.getTrackInfoForBranch(repository, currentBranch);
        if (trackInfo != null) {
            return new GitPushTarget(trackInfo.getRemoteBranch(), false);
        }
        return GitPushSupport.proposeTargetForNewBranch(repository, currentBranch);
    }

    private GitPushTarget getPersistedTarget(GitRepository repository, GitLocalBranch branch) {
        GitRemoteBranch target = this.mySettings.getPushTarget(repository, branch.getName());
        return target == null ? null : new GitPushTarget(target, !repository.getBranches().getRemoteBranches().contains(target));
    }

    private static GitPushTarget proposeTargetForNewBranch(GitRepository repository, GitLocalBranch currentBranch) {
        Collection<GitRemote> remotes = repository.getRemotes();
        if (remotes.isEmpty()) {
            return null;
        }
        if (remotes.size() == 1) {
            return GitPushSupport.makeTargetForNewBranch(repository, remotes.iterator().next(), currentBranch);
        }
        GitRemote remote = GitUtil.getDefaultRemote(remotes);
        if (remote == null) {
            remote = remotes.iterator().next();
        }
        return GitPushSupport.makeTargetForNewBranch(repository, remote, currentBranch);
    }

    private static GitPushTarget makeTargetForNewBranch(GitRepository repository, GitRemote remote, GitLocalBranch currentBranch) {
        GitRemoteBranch existingRemoteBranch = GitUtil.findRemoteBranch(repository, remote, currentBranch.getName());
        if (existingRemoteBranch != null) {
            return new GitPushTarget(existingRemoteBranch, false);
        }
        return new GitPushTarget(new GitStandardRemoteBranch(remote, currentBranch.getName(), GitBranch.DUMMY_HASH), true);
    }

    public GitPushSource getSource(GitRepository repository) {
        GitLocalBranch currentBranch = repository.getCurrentBranch();
        return currentBranch != null ? GitPushSource.create(currentBranch) : GitPushSource.create((String)ObjectUtils.assertNotNull((Object)repository.getCurrentRevision()));
    }

    public RepositoryManager<GitRepository> getRepositoryManager() {
        return this.myRepositoryManager;
    }

    public PushTargetPanel<GitPushTarget> createTargetPanel(GitRepository repository, GitPushTarget defaultTarget) {
        return new GitPushTargetPanel(this, repository, defaultTarget);
    }

    public boolean isForcePushAllowed(GitRepository repo, GitPushTarget target) {
        final String targetBranch = target.getBranch().getNameForRemoteOperations();
        return !ContainerUtil.exists(this.mySharedSettings.getForcePushProhibitedPatterns(), (Condition)new Condition<String>(){

            public boolean value(String pattern) {
                return targetBranch.matches("^" + pattern + "$");
            }
        });
    }

    public boolean isForcePushEnabled() {
        return this.mySettings.isForcePushAllowed();
    }

    public VcsPushOptionsPanel createOptionsPanel() {
        return new GitPushTagPanel(this.mySettings.getPushTagMode(), GitVersionSpecialty.SUPPORTS_FOLLOW_TAGS.existsIn(this.myVcs.getVersion()));
    }

    public boolean isSilentForcePushAllowed(GitPushTarget target) {
        return this.myCommonPushSettings.containsForcePushTarget(target.getBranch().getRemote().getName(), target.getBranch().getNameForRemoteOperations());
    }

    public void saveSilentForcePushTarget(GitPushTarget target) {
        this.myCommonPushSettings.addForcePushTarget(target.getBranch().getRemote().getName(), target.getBranch().getNameForRemoteOperations());
    }

    public boolean mayChangeTargetsSync() {
        return true;
    }
}

