/*
 * Decompiled with CFR 0.152.
 */
package git4idea.push;

import com.intellij.dvcs.push.PushTargetPanel;
import com.intellij.dvcs.push.ui.PushLogTreeUtil;
import com.intellij.dvcs.push.ui.PushTargetEditorListener;
import com.intellij.dvcs.push.ui.PushTargetTextField;
import com.intellij.dvcs.push.ui.VcsEditableTextComponent;
import com.intellij.dvcs.push.ui.VcsLinkListener;
import com.intellij.dvcs.push.ui.VcsLinkedTextComponent;
import com.intellij.openapi.command.undo.UndoConstants;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.popup.list.ListPopupImpl;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.table.ComponentsListFocusTraversalPolicy;
import git4idea.GitRemoteBranch;
import git4idea.commands.Git;
import git4idea.commands.GitCommandResult;
import git4idea.push.GitDefineRemoteDialog;
import git4idea.push.GitPushSupport;
import git4idea.push.GitPushTarget;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import git4idea.validators.GitRefNameValidator;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.Point;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.text.ParseException;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.tree.DefaultMutableTreeNode;

public class GitPushTargetPanel
extends PushTargetPanel<GitPushTarget> {
    private static final Logger LOG = Logger.getInstance(GitPushTargetPanel.class);
    private static final Comparator<GitRemoteBranch> REMOTE_BRANCH_COMPARATOR = new MyRemoteBranchComparator();
    private static final String SEPARATOR = " : ";
    private final GitPushSupport myPushSupport;
    private final GitRepository myRepository;
    private final Git myGit;
    private final VcsEditableTextComponent myTargetRenderer;
    private final PushTargetTextField myTargetEditor;
    private final VcsLinkedTextComponent myRemoteRenderer;
    private final Project myProject;
    private GitPushTarget myCurrentTarget;
    private String myError;
    private Runnable myFireOnChangeAction;

    public GitPushTargetPanel(GitPushSupport support, GitRepository repository, GitPushTarget defaultTarget) {
        this.myPushSupport = support;
        this.myRepository = repository;
        this.myGit = (Git)ServiceManager.getService(Git.class);
        this.myProject = this.myRepository.getProject();
        this.myTargetRenderer = new VcsEditableTextComponent("", null);
        this.myTargetEditor = new PushTargetTextField(repository.getProject(), GitPushTargetPanel.getTargetNames(this.myRepository), "");
        this.myRemoteRenderer = new VcsLinkedTextComponent("", new VcsLinkListener(){

            public void hyperlinkActivated(DefaultMutableTreeNode sourceNode, MouseEvent event) {
                if (GitPushTargetPanel.this.myRepository.getRemotes().isEmpty()) {
                    GitPushTargetPanel.this.showDefineRemoteDialog();
                } else {
                    Component eventComponent = event.getComponent();
                    if (eventComponent != null) {
                        GitPushTargetPanel.this.showRemoteSelector(eventComponent, event.getPoint());
                    }
                }
            }
        });
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
        JPanel remoteAndSeparator = new JPanel(new BorderLayout());
        remoteAndSeparator.setOpaque(false);
        remoteAndSeparator.add((Component)this.myRemoteRenderer, "Center");
        remoteAndSeparator.add((Component)new JBLabel(SEPARATOR), "East");
        this.add(remoteAndSeparator, "West");
        this.add((Component)this.myTargetEditor, "Center");
        this.updateComponents(defaultTarget);
        this.setFocusCycleRoot(true);
        this.setFocusTraversalPolicyProvider(true);
        this.myRemoteRenderer.setFocusable(true);
        this.myTargetEditor.setFocusable(true);
        this.setFocusTraversalPolicy((FocusTraversalPolicy)((Object)new MyGitTargetFocusTraversalPolicy()));
        this.myRemoteRenderer.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                if (GitPushTargetPanel.this.myTargetEditor.isShowing()) {
                    GitPushTargetPanel.this.showRemoteSelector((Component)GitPushTargetPanel.this.myRemoteRenderer, new Point(GitPushTargetPanel.this.myRemoteRenderer.getLocation()));
                }
            }
        });
        this.myTargetEditor.getDocument().putUserData(UndoConstants.DONT_RECORD_UNDO, (Object)Boolean.TRUE);
    }

    private void updateComponents(GitPushTarget target) {
        this.myCurrentTarget = target;
        String initialBranch = "";
        String initialRemote = "";
        boolean noRemotes = this.myRepository.getRemotes().isEmpty();
        if (target == null) {
            if (this.myRepository.getCurrentBranch() == null) {
                this.myError = "Detached HEAD";
            } else if (this.myRepository.isFresh()) {
                this.myError = "Empty repository";
            } else if (!noRemotes) {
                this.myError = "Can't push";
            }
        } else {
            initialBranch = GitPushTargetPanel.getTextFieldText(target);
            initialRemote = target.getBranch().getRemote().getName();
        }
        this.myTargetRenderer.updateLinkText(initialBranch);
        this.myTargetEditor.setText(initialBranch);
        this.myRemoteRenderer.updateLinkText(noRemotes ? "Define remote" : initialRemote);
        this.myTargetEditor.setVisible(!noRemotes);
    }

    private void showDefineRemoteDialog() {
        GitDefineRemoteDialog dialog = new GitDefineRemoteDialog(this.myRepository.getProject());
        if (dialog.showAndGet()) {
            String url;
            String name = dialog.getRemoteName();
            String error = this.validateRemoteUnderModal(name, url = dialog.getRemoteUrl());
            if (error != null) {
                LOG.warn(String.format("Invalid remote. Name: [%s], URL: [%s], error: %s", name, url, error));
                Messages.showErrorDialog((Project)this.myRepository.getProject(), (String)error, (String)"Invalid Remote URL");
            } else {
                this.addRemoteUnderModal(name, url);
            }
        }
    }

    private String validateRemoteUnderModal(String name, final String url) {
        if (url.isEmpty()) {
            return "URL can't be empty";
        }
        if (!GitRefNameValidator.getInstance().checkInput(name)) {
            return "Remote name is invalid";
        }
        final Ref error = Ref.create();
        ProgressManager.getInstance().run((Task)new Task.Modal(this.myRepository.getProject(), "Checking URL...", false){

            public void run(ProgressIndicator indicator) {
                indicator.setIndeterminate(true);
                GitCommandResult result = GitPushTargetPanel.this.myGit.lsRemote(GitPushTargetPanel.this.myRepository.getProject(), VfsUtilCore.virtualToIoFile((VirtualFile)GitPushTargetPanel.this.myRepository.getRoot()), url);
                if (!result.success()) {
                    error.set((Object)("Remote URL is invalid: " + result.getErrorOutputAsHtmlString()));
                }
            }
        });
        return (String)error.get();
    }

    private void addRemoteUnderModal(final String remoteName, final String remoteUrl) {
        ProgressManager.getInstance().run((Task)new Task.Modal(this.myRepository.getProject(), "Adding remote...", false){
            private GitCommandResult myResult;

            public void run(ProgressIndicator indicator) {
                indicator.setIndeterminate(true);
                this.myResult = GitPushTargetPanel.this.myGit.addRemote(GitPushTargetPanel.this.myRepository, remoteName, remoteUrl);
                GitPushTargetPanel.this.myRepository.update();
            }

            public void onSuccess() {
                if (this.myResult.success()) {
                    GitPushTargetPanel.this.updateComponents(GitPushTargetPanel.this.myPushSupport.getDefaultTarget(GitPushTargetPanel.this.myRepository));
                    if (GitPushTargetPanel.this.myFireOnChangeAction != null) {
                        GitPushTargetPanel.this.myFireOnChangeAction.run();
                    }
                } else {
                    String message = "Couldn't add remote: " + this.myResult.getErrorOutputAsHtmlString();
                    LOG.warn(message);
                    Messages.showErrorDialog((Project)this.myProject, (String)message, (String)"Add Remote");
                }
            }
        });
    }

    private void showRemoteSelector(Component component, Point point) {
        List<String> remotes = this.getRemotes();
        if (remotes.size() <= 1) {
            return;
        }
        ListPopupImpl popup = new ListPopupImpl((ListPopupStep)new BaseListPopupStep<String>(null, remotes){

            public PopupStep onChosen(String selectedValue, boolean finalChoice) {
                GitPushTargetPanel.this.myRemoteRenderer.updateLinkText(selectedValue);
                if (GitPushTargetPanel.this.myFireOnChangeAction != null && !GitPushTargetPanel.this.myTargetEditor.isShowing()) {
                    GitPushTargetPanel.this.myFireOnChangeAction.run();
                }
                return super.onChosen((Object)selectedValue, finalChoice);
            }
        }){

            public void cancel(InputEvent e) {
                super.cancel(e);
                if (GitPushTargetPanel.this.myTargetEditor.isShowing()) {
                    GitPushTargetPanel.this.repaint();
                    IdeFocusManager.getInstance((Project)GitPushTargetPanel.this.myProject).requestFocus((Component)GitPushTargetPanel.this.myTargetEditor, true);
                }
            }
        };
        popup.show(new RelativePoint(component, point));
    }

    private List<String> getRemotes() {
        return ContainerUtil.map(this.myRepository.getRemotes(), (Function)new Function<GitRemote, String>(){

            public String fun(GitRemote remote) {
                return remote.getName();
            }
        });
    }

    public void render(ColoredTreeCellRenderer renderer, boolean isSelected, boolean isActive, String forceRenderedText) {
        SimpleTextAttributes targetTextAttributes = PushLogTreeUtil.addTransparencyIfNeeded((SimpleTextAttributes)SimpleTextAttributes.REGULAR_ATTRIBUTES, (boolean)isActive);
        if (this.myError != null) {
            renderer.append(this.myError, PushLogTreeUtil.addTransparencyIfNeeded((SimpleTextAttributes)SimpleTextAttributes.ERROR_ATTRIBUTES, (boolean)isActive));
        } else {
            String currentRemote = this.myRemoteRenderer.getText();
            List<String> remotes = this.getRemotes();
            if (remotes.isEmpty() || remotes.size() > 1) {
                this.myRemoteRenderer.setSelected(isSelected);
                this.myRemoteRenderer.setTransparent(!remotes.isEmpty() && !isActive);
                this.myRemoteRenderer.render(renderer);
            } else {
                renderer.append(currentRemote, targetTextAttributes);
            }
            if (!remotes.isEmpty()) {
                renderer.append(SEPARATOR, targetTextAttributes);
                if (forceRenderedText != null) {
                    renderer.append(forceRenderedText);
                    return;
                }
                GitPushTarget target = this.getValue();
                if (target != null && target.isNewBranchCreated()) {
                    renderer.append("+", PushLogTreeUtil.addTransparencyIfNeeded((SimpleTextAttributes)SimpleTextAttributes.SYNTHETIC_ATTRIBUTES, (boolean)isActive), (Object)this);
                }
                this.myTargetRenderer.setSelected(isSelected);
                this.myTargetRenderer.setTransparent(!isActive);
                this.myTargetRenderer.render(renderer);
            }
        }
    }

    public GitPushTarget getValue() {
        return this.myCurrentTarget;
    }

    private static String getTextFieldText(GitPushTarget target) {
        return target != null ? target.getBranch().getNameForRemoteOperations() : "";
    }

    public void fireOnCancel() {
        this.myTargetEditor.setText(GitPushTargetPanel.getTextFieldText(this.myCurrentTarget));
    }

    public void fireOnChange() {
        if (this.myError != null || this.myRepository.getRemotes().isEmpty()) {
            return;
        }
        String remoteName = this.myRemoteRenderer.getText();
        String branchName = this.myTargetEditor.getText();
        try {
            this.myCurrentTarget = GitPushTarget.parse(this.myRepository, remoteName, branchName);
            this.myTargetRenderer.updateLinkText(branchName);
        }
        catch (ParseException e) {
            LOG.error("Invalid remote name shouldn't be allowed. [" + remoteName + ", " + branchName + "]", (Throwable)e);
        }
    }

    public ValidationInfo verify() {
        if (this.myError != null) {
            return new ValidationInfo(this.myError, (JComponent)this.myTargetEditor);
        }
        try {
            GitPushTarget.parse(this.myRepository, this.myRemoteRenderer.getText(), this.myTargetEditor.getText());
            return null;
        }
        catch (ParseException e) {
            return new ValidationInfo(e.getMessage(), (JComponent)this.myTargetEditor);
        }
    }

    public void setFireOnChangeAction(Runnable action) {
        this.myFireOnChangeAction = action;
    }

    private static List<String> getTargetNames(GitRepository repository) {
        List remoteBranches = ContainerUtil.sorted(repository.getBranches().getRemoteBranches(), REMOTE_BRANCH_COMPARATOR);
        return ContainerUtil.map((Collection)remoteBranches, (Function)new Function<GitRemoteBranch, String>(){

            public String fun(GitRemoteBranch branch) {
                return branch.getNameForRemoteOperations();
            }
        });
    }

    public void addTargetEditorListener(final PushTargetEditorListener listener) {
        this.myTargetEditor.addDocumentListener((DocumentListener)new DocumentAdapter(){

            public void documentChanged(DocumentEvent e) {
                GitPushTargetPanel.this.processActiveUserChanges(listener);
            }
        });
        this.myTargetEditor.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                GitPushTargetPanel.this.processActiveUserChanges(listener);
            }
        });
        this.myTargetEditor.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                if ((e.getChangeFlags() & 4L) != 0L) {
                    GitPushTargetPanel.this.myTargetEditor.getDocument().putUserData(UndoConstants.DONT_RECORD_UNDO, (Object)(!GitPushTargetPanel.this.myTargetEditor.isShowing() ? 1 : 0));
                }
            }
        });
    }

    private void processActiveUserChanges(PushTargetEditorListener listener) {
        if (this.myTargetEditor.isShowing()) {
            listener.onTargetInEditModeChanged(this.myTargetEditor.getText());
        }
    }

    public void forceUpdateEditableUiModel(String forcedText) {
        if (!this.myTargetEditor.isShowing()) {
            this.myTargetEditor.setText(forcedText);
        }
    }

    private class MyGitTargetFocusTraversalPolicy
    extends ComponentsListFocusTraversalPolicy {
        private MyGitTargetFocusTraversalPolicy() {
        }

        protected List<Component> getOrderedComponents() {
            return ContainerUtil.newArrayList((Object[])new Component[]{GitPushTargetPanel.this.myTargetEditor.getFocusTarget(), GitPushTargetPanel.this.myRemoteRenderer});
        }

        public Component getComponentAfter(Container aContainer, Component aComponent) {
            if (GitPushTargetPanel.this.getRemotes().size() > 1) {
                return super.getComponentAfter(aContainer, aComponent);
            }
            return aComponent;
        }

        public Component getComponentBefore(Container aContainer, Component aComponent) {
            if (GitPushTargetPanel.this.getRemotes().size() > 1) {
                return super.getComponentBefore(aContainer, aComponent);
            }
            return aComponent;
        }
    }

    private static class MyRemoteBranchComparator
    implements Comparator<GitRemoteBranch> {
        private MyRemoteBranchComparator() {
        }

        @Override
        public int compare(GitRemoteBranch o1, GitRemoteBranch o2) {
            String remoteName2;
            String remoteName1 = o1.getRemote().getName();
            int remoteComparison = remoteName1.compareTo(remoteName2 = o2.getRemote().getName());
            if (remoteComparison != 0) {
                if (remoteName1.equals("origin")) {
                    return -1;
                }
                if (remoteName2.equals("origin")) {
                    return 1;
                }
                return remoteComparison;
            }
            return o1.getNameForLocalOperations().compareTo(o2.getNameForLocalOperations());
        }
    }
}

