/*
 * Decompiled with CFR 0.152.
 */
package git4idea.rebase;

import com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.annotations.NonNls;

class GitRebaseEntry {
    private static final Logger log = Logger.getInstance((String)GitRebaseEntry.class.getName());
    private final String myCommit;
    private final String mySubject;
    private Action myAction;

    public GitRebaseEntry(String action, String commit, String subject) {
        this.myCommit = commit;
        this.mySubject = subject;
        this.myAction = Action.fromString(action);
    }

    public String getCommit() {
        return this.myCommit;
    }

    public String getSubject() {
        return this.mySubject;
    }

    public Action getAction() {
        return this.myAction;
    }

    public void setAction(Action action) {
        if (action == null) {
            log.error("The action must not be null");
        } else {
            this.myAction = action;
        }
    }

    public static enum Action {
        pick,
        edit,
        skip,
        squash,
        reword,
        fixup;


        static Action fromString(@NonNls String actionName) {
            try {
                return Action.valueOf(actionName.toLowerCase());
            }
            catch (IllegalArgumentException e) {
                log.error((Throwable)e);
                return pick;
            }
        }
    }
}

