/*
 * Decompiled with CFR 0.152.
 */
package git4idea.rebase;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.GitRevisionNumber;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;

public class GitRebaseUtils {
    private static final Logger LOG = Logger.getInstance((String)GitRebaseUtils.class.getName());

    private GitRebaseUtils() {
    }

    @Deprecated
    public static boolean isRebaseInTheProgress(VirtualFile root) {
        return GitRebaseUtils.getRebaseDir(root) != null;
    }

    private static File getRebaseDir(VirtualFile root) {
        File gitDir = new File(VfsUtilCore.virtualToIoFile((VirtualFile)root), ".git");
        File f = new File(gitDir, "rebase-apply");
        if (f.exists()) {
            return f;
        }
        f = new File(gitDir, "rebase-merge");
        if (f.exists()) {
            return f;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CommitInfo getCurrentRebaseCommit(VirtualFile root) {
        int next;
        File rebaseDir = GitRebaseUtils.getRebaseDir(root);
        if (rebaseDir == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("No rebase dir found for " + root.getPath());
            }
            return null;
        }
        File nextFile = new File(rebaseDir, "next");
        try {
            next = Integer.parseInt(FileUtil.loadFile((File)nextFile, (Charset)CharsetToolkit.UTF8_CHARSET).trim());
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Failed to load next commit number from file " + nextFile.getPath(), (Throwable)e);
            }
            return null;
        }
        File commitFile = new File(rebaseDir, String.format("%04d", next));
        String hash = null;
        String subject = null;
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(commitFile), CharsetToolkit.UTF8_CHARSET));
            try {
                String line;
                while ((line = in.readLine()) != null) {
                    if (line.startsWith("From ")) {
                        hash = line.substring(5, 45);
                    }
                    if (line.startsWith("Subject: ")) {
                        subject = line.substring("Subject: ".length());
                    }
                    if (hash == null || subject == null) continue;
                    break;
                }
            }
            finally {
                in.close();
            }
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Failed to load next commit number from file " + commitFile, (Throwable)e);
            }
            return null;
        }
        if (subject == null || hash == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Unable to extract information from " + commitFile + " " + hash + ": " + subject);
            }
            return null;
        }
        return new CommitInfo(new GitRevisionNumber(hash), subject);
    }

    public static class CommitInfo {
        public final GitRevisionNumber revision;
        public final String subject;

        public CommitInfo(GitRevisionNumber revision, String subject) {
            this.revision = revision;
            this.subject = subject;
        }

        public String toString() {
            return this.revision.toString();
        }
    }
}

