/*
 * Decompiled with CFR 0.152.
 */
package git4idea.repo;

import com.intellij.dvcs.repo.Repository;
import git4idea.GitBranch;
import git4idea.GitLocalBranch;
import git4idea.GitRemoteBranch;
import git4idea.repo.GitBranchTrackInfo;
import git4idea.repo.GitRemote;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;

public class GitRepoInfo {
    private final GitLocalBranch myCurrentBranch;
    private final String myCurrentRevision;
    private final Repository.State myState;
    private final Set<GitRemote> myRemotes;
    private final Set<GitLocalBranch> myLocalBranches;
    private final Set<GitRemoteBranch> myRemoteBranches;
    private final Set<GitBranchTrackInfo> myBranchTrackInfos;

    public GitRepoInfo(GitLocalBranch currentBranch, String currentRevision, Repository.State state, Collection<GitRemote> remotes, Collection<GitLocalBranch> localBranches, Collection<GitRemoteBranch> remoteBranches, Collection<GitBranchTrackInfo> branchTrackInfos) {
        this.myCurrentBranch = currentBranch;
        this.myCurrentRevision = currentRevision;
        this.myState = state;
        this.myRemotes = new LinkedHashSet<GitRemote>(remotes);
        this.myLocalBranches = new LinkedHashSet<GitLocalBranch>(localBranches);
        this.myRemoteBranches = new LinkedHashSet<GitRemoteBranch>(remoteBranches);
        this.myBranchTrackInfos = new LinkedHashSet<GitBranchTrackInfo>(branchTrackInfos);
    }

    public GitLocalBranch getCurrentBranch() {
        return this.myCurrentBranch;
    }

    public Collection<GitRemote> getRemotes() {
        return this.myRemotes;
    }

    public Collection<GitLocalBranch> getLocalBranches() {
        return this.myLocalBranches;
    }

    public Collection<GitRemoteBranch> getRemoteBranches() {
        return this.myRemoteBranches;
    }

    public Collection<GitBranchTrackInfo> getBranchTrackInfos() {
        return this.myBranchTrackInfos;
    }

    public String getCurrentRevision() {
        return this.myCurrentRevision;
    }

    public Repository.State getState() {
        return this.myState;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GitRepoInfo info = (GitRepoInfo)o;
        if (this.myState != info.myState) {
            return false;
        }
        if (this.myCurrentRevision != null ? !this.myCurrentRevision.equals(info.myCurrentRevision) : info.myCurrentRevision != null) {
            return false;
        }
        if (this.myCurrentBranch != null ? !this.myCurrentBranch.equals(info.myCurrentBranch) : info.myCurrentBranch != null) {
            return false;
        }
        if (!((Object)this.myRemotes).equals(info.myRemotes)) {
            return false;
        }
        if (!((Object)this.myBranchTrackInfos).equals(info.myBranchTrackInfos)) {
            return false;
        }
        if (!GitRepoInfo.areEqual(this.myLocalBranches, info.myLocalBranches)) {
            return false;
        }
        return GitRepoInfo.areEqual(this.myRemoteBranches, info.myRemoteBranches);
    }

    public int hashCode() {
        int result = this.myCurrentBranch != null ? this.myCurrentBranch.hashCode() : 0;
        result = 31 * result + (this.myCurrentRevision != null ? this.myCurrentRevision.hashCode() : 0);
        result = 31 * result + this.myState.hashCode();
        result = 31 * result + ((Object)this.myRemotes).hashCode();
        result = 31 * result + ((Object)this.myLocalBranches).hashCode();
        result = 31 * result + ((Object)this.myRemoteBranches).hashCode();
        result = 31 * result + ((Object)this.myBranchTrackInfos).hashCode();
        return result;
    }

    public String toString() {
        return String.format("GitRepoInfo{current=%s, remotes=%s, localBranches=%s, remoteBranches=%s, trackInfos=%s}", this.myCurrentBranch, this.myRemotes, this.myLocalBranches, this.myRemoteBranches, this.myBranchTrackInfos);
    }

    private static <T extends GitBranch> boolean areEqual(Collection<T> c1, Collection<T> c2) {
        THashSet set1 = new THashSet(c1, (TObjectHashingStrategy)new BranchesComparingStrategy());
        THashSet set2 = new THashSet(c2, (TObjectHashingStrategy)new BranchesComparingStrategy());
        return set1.equals((Object)set2);
    }

    private static class BranchesComparingStrategy
    implements TObjectHashingStrategy<GitBranch> {
        private BranchesComparingStrategy() {
        }

        public int computeHashCode(GitBranch branch) {
            return 31 * branch.getName().hashCode() + branch.getHash().hashCode();
        }

        public boolean equals(GitBranch b1, GitBranch b2) {
            if (b1 == b2) {
                return true;
            }
            if (b1.getClass() != b2.getClass()) {
                return false;
            }
            return b1.getName().equals(b2.getName()) && b1.getHash().equals(b2.getHash());
        }
    }
}

