/*
 * Decompiled with CFR 0.152.
 */
package git4idea.repo;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.repo.Repository;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.util.Consumer;
import com.intellij.util.concurrency.QueueProcessor;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryChangeListener;
import git4idea.repo.GitRepositoryFiles;
import git4idea.util.GitFileUtils;
import java.util.List;

final class GitRepositoryUpdater
implements Disposable,
BulkFileListener {
    private final GitRepository myRepository;
    private final GitRepositoryFiles myRepositoryFiles;
    private final MessageBusConnection myMessageBusConnection;
    private final QueueProcessor<Object> myUpdateQueue;
    private final Object DUMMY_UPDATE_OBJECT = new Object();
    private final VirtualFile myRemotesDir;
    private final VirtualFile myHeadsDir;
    private final VirtualFile myTagsDir;
    private final LocalFileSystem.WatchRequest myWatchRequest;

    GitRepositoryUpdater(GitRepository repository) {
        this.myRepository = repository;
        VirtualFile gitDir = repository.getGitDir();
        this.myWatchRequest = LocalFileSystem.getInstance().addRootToWatch(gitDir.getPath(), true);
        this.myRepositoryFiles = GitRepositoryFiles.getInstance(gitDir);
        DvcsUtil.visitVcsDirVfs((VirtualFile)gitDir, GitRepositoryFiles.getSubDirRelativePaths());
        this.myHeadsDir = VcsUtil.getVirtualFile((String)this.myRepositoryFiles.getRefsHeadsPath());
        this.myRemotesDir = VcsUtil.getVirtualFile((String)this.myRepositoryFiles.getRefsRemotesPath());
        this.myTagsDir = VcsUtil.getVirtualFile((String)this.myRepositoryFiles.getRefsTagsPath());
        Project project = repository.getProject();
        this.myUpdateQueue = new QueueProcessor((Consumer)new DvcsUtil.Updater((Repository)repository), project.getDisposed());
        if (!project.isDisposed()) {
            this.myMessageBusConnection = project.getMessageBus().connect();
            this.myMessageBusConnection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)this);
        } else {
            this.myMessageBusConnection = null;
        }
    }

    public void dispose() {
        if (this.myWatchRequest != null) {
            LocalFileSystem.getInstance().removeWatchedRoot(this.myWatchRequest);
        }
        if (this.myMessageBusConnection != null) {
            this.myMessageBusConnection.disconnect();
        }
    }

    public void before(List<? extends VFileEvent> events) {
    }

    public void after(List<? extends VFileEvent> events) {
        boolean configChanged = false;
        boolean headChanged = false;
        boolean branchFileChanged = false;
        boolean packedRefsChanged = false;
        boolean rebaseFileChanged = false;
        boolean mergeFileChanged = false;
        boolean tagChanged = false;
        for (VFileEvent vFileEvent : events) {
            String filePath = GitFileUtils.stripFileProtocolPrefix(vFileEvent.getPath());
            if (this.myRepositoryFiles.isConfigFile(filePath)) {
                configChanged = true;
                continue;
            }
            if (this.myRepositoryFiles.isHeadFile(filePath)) {
                headChanged = true;
                continue;
            }
            if (this.myRepositoryFiles.isBranchFile(filePath)) {
                branchFileChanged = true;
                DvcsUtil.ensureAllChildrenInVfs((VirtualFile)this.myHeadsDir);
                continue;
            }
            if (this.myRepositoryFiles.isRemoteBranchFile(filePath)) {
                branchFileChanged = true;
                DvcsUtil.ensureAllChildrenInVfs((VirtualFile)this.myRemotesDir);
                continue;
            }
            if (this.myRepositoryFiles.isPackedRefs(filePath)) {
                packedRefsChanged = true;
                continue;
            }
            if (this.myRepositoryFiles.isRebaseFile(filePath)) {
                rebaseFileChanged = true;
                continue;
            }
            if (this.myRepositoryFiles.isMergeFile(filePath)) {
                mergeFileChanged = true;
                continue;
            }
            if (!this.myRepositoryFiles.isTagFile(filePath)) continue;
            DvcsUtil.ensureAllChildrenInVfs((VirtualFile)this.myTagsDir);
            tagChanged = true;
        }
        if (headChanged || configChanged || branchFileChanged || packedRefsChanged || rebaseFileChanged || mergeFileChanged) {
            this.myUpdateQueue.add(this.DUMMY_UPDATE_OBJECT);
        } else if (tagChanged) {
            ((GitRepositoryChangeListener)this.myRepository.getProject().getMessageBus().syncPublisher(GitRepository.GIT_REPO_CHANGE)).repositoryChanged(this.myRepository);
        }
    }
}

