/*
 * Decompiled with CFR 0.152.
 */
package git4idea.reset;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.repo.Repository;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBRadioButton;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.RadioButtonEnumModel;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.xml.util.XmlStringUtil;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.reset.GitResetMode;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class GitNewResetDialog
extends DialogWrapper {
    private static final String DIALOG_ID = "git.new.reset.dialog";
    private final Project myProject;
    private final Map<GitRepository, VcsFullCommitDetails> myCommits;
    private final GitResetMode myDefaultMode;
    private final ButtonGroup myButtonGroup;
    private RadioButtonEnumModel<GitResetMode> myEnumModel;

    protected GitNewResetDialog(Project project, Map<GitRepository, VcsFullCommitDetails> commits, GitResetMode defaultMode) {
        super(project);
        this.myProject = project;
        this.myCommits = commits;
        this.myDefaultMode = defaultMode;
        this.myButtonGroup = new ButtonGroup();
        this.init();
        this.setTitle("Git Reset");
        this.setOKButtonText("Reset");
        this.setOKButtonMnemonic(82);
        this.setResizable(false);
    }

    protected JComponent createCenterPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBag gb = new GridBag().setDefaultAnchor(21).setDefaultInsets(0, 10, 12, 0);
        String description = GitNewResetDialog.prepareDescription(this.myProject, this.myCommits);
        panel.add((Component)new JBLabel(XmlStringUtil.wrapInHtml((CharSequence)description)), gb.nextLine().next().coverLine());
        String explanation = "This will reset the current branch head to the selected commit, <br/>and update the working tree and the index according to the selected mode:";
        panel.add((Component)new JBLabel(XmlStringUtil.wrapInHtml((CharSequence)explanation), UIUtil.ComponentStyle.SMALL), gb.nextLine().next().coverLine());
        for (GitResetMode mode : GitResetMode.values()) {
            JBRadioButton button = new JBRadioButton(mode.getName());
            button.setMnemonic(mode.getName().charAt(0));
            this.myButtonGroup.add((AbstractButton)button);
            panel.add((Component)button, gb.nextLine().next());
            panel.add((Component)new JBLabel(XmlStringUtil.wrapInHtml((CharSequence)mode.getDescription()), UIUtil.ComponentStyle.SMALL), gb.next());
        }
        this.myEnumModel = RadioButtonEnumModel.bindEnum(GitResetMode.class, (ButtonGroup)this.myButtonGroup);
        this.myEnumModel.setSelected((Enum)this.myDefaultMode);
        return panel;
    }

    protected String getHelpId() {
        return DIALOG_ID;
    }

    private static String prepareDescription(Project project, Map<GitRepository, VcsFullCommitDetails> commits) {
        if (commits.size() == 1 && !GitNewResetDialog.isMultiRepo(project)) {
            Map.Entry<GitRepository, VcsFullCommitDetails> entry = commits.entrySet().iterator().next();
            return String.format("%s -> %s", GitNewResetDialog.getSourceText(entry.getKey()), GitNewResetDialog.getTargetText(entry.getValue()));
        }
        StringBuilder desc = new StringBuilder("");
        for (Map.Entry<GitRepository, VcsFullCommitDetails> entry : commits.entrySet()) {
            GitRepository repository = entry.getKey();
            VcsFullCommitDetails commit = entry.getValue();
            desc.append(String.format("%s in %s -> %s<br/>", GitNewResetDialog.getSourceText(repository), DvcsUtil.getShortRepositoryName((Repository)repository), GitNewResetDialog.getTargetText(commit)));
        }
        return desc.toString();
    }

    private static String getTargetText(VcsFullCommitDetails commit) {
        String commitMessage = StringUtil.escapeXml((String)StringUtil.shortenTextWithEllipsis((String)commit.getSubject(), (int)20, (int)0));
        return String.format("<code><b>%s</b> \"%s\"</code> by <code>%s</code>", ((Hash)commit.getId()).toShortString(), commitMessage, commit.getAuthor().getName());
    }

    private static String getSourceText(GitRepository repository) {
        String currentRevision = repository.getCurrentRevision();
        assert (currentRevision != null);
        String text = repository.getCurrentBranch() == null ? "HEAD (" + DvcsUtil.getShortHash((String)currentRevision) + ")" : repository.getCurrentBranch().getName();
        return "<b>" + text + "</b>";
    }

    private static boolean isMultiRepo(Project project) {
        return ((GitRepositoryManager)((Object)ServiceManager.getService((Project)project, GitRepositoryManager.class))).moreThanOneRoot();
    }

    public GitResetMode getResetMode() {
        return (GitResetMode)this.myEnumModel.getSelected();
    }
}

