/*
 * Decompiled with CFR 0.152.
 */
package git4idea.stash;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.ChangeListManagerEx;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.continuation.ContinuationContext;
import git4idea.GitPlatformFacade;
import git4idea.commands.Git;
import git4idea.config.GitVcsSettings;
import git4idea.merge.GitConflictResolver;
import git4idea.stash.GitShelveChangesSaver;
import git4idea.stash.GitStashChangesSaver;
import java.util.Collection;
import javax.swing.event.HyperlinkEvent;

public abstract class GitChangesSaver {
    private static final Logger LOG = Logger.getInstance(GitChangesSaver.class);
    protected final Project myProject;
    protected final GitPlatformFacade myPlatformFacade;
    protected final ChangeListManagerEx myChangeManager;
    protected final Git myGit;
    protected final ProgressIndicator myProgressIndicator;
    protected final String myStashMessage;
    protected GitConflictResolver.Params myParams;

    public abstract void refresh();

    public static GitChangesSaver getSaver(Project project, GitPlatformFacade platformFacade, Git git, ProgressIndicator progressIndicator, String stashMessage) {
        GitVcsSettings settings = GitVcsSettings.getInstance(project);
        if (settings == null) {
            return GitChangesSaver.getDefaultSaver(project, platformFacade, git, progressIndicator, stashMessage);
        }
        switch (settings.updateChangesPolicy()) {
            case STASH: {
                return new GitStashChangesSaver(project, platformFacade, git, progressIndicator, stashMessage);
            }
            case SHELVE: {
                return new GitShelveChangesSaver(project, platformFacade, git, progressIndicator, stashMessage);
            }
        }
        return GitChangesSaver.getDefaultSaver(project, platformFacade, git, progressIndicator, stashMessage);
    }

    private static GitChangesSaver getDefaultSaver(Project project, GitPlatformFacade platformFacade, Git git, ProgressIndicator progressIndicator, String stashMessage) {
        return new GitStashChangesSaver(project, platformFacade, git, progressIndicator, stashMessage);
    }

    protected GitChangesSaver(Project project, GitPlatformFacade platformFacade, Git git, ProgressIndicator indicator, String stashMessage) {
        this.myProject = project;
        this.myPlatformFacade = platformFacade;
        this.myGit = git;
        this.myProgressIndicator = indicator;
        this.myStashMessage = stashMessage;
        this.myChangeManager = platformFacade.getChangeListManager(project);
    }

    public void saveLocalChanges(Collection<VirtualFile> rootsToSave) throws VcsException {
        if (rootsToSave == null || rootsToSave.isEmpty()) {
            return;
        }
        this.save(rootsToSave);
    }

    public void restoreLocalChanges(ContinuationContext context) {
        this.load(context);
    }

    public void notifyLocalChangesAreNotRestored() {
        if (this.wereChangesSaved()) {
            LOG.info("Update is incomplete, changes are not restored");
            VcsNotifier.getInstance((Project)this.myProject).notifyImportantWarning("Local changes were not restored", "Before update your uncommitted changes were saved to <a href='saver'>" + this.getSaverName() + "</a>.<br/>" + "Update is not complete, you have unresolved merges in your working tree<br/>" + "Resolve conflicts, complete update and restore changes manually.", (NotificationListener)new ShowSavedChangesNotificationListener());
        }
    }

    public void setConflictResolverParams(GitConflictResolver.Params params) {
        this.myParams = params;
    }

    protected abstract void save(Collection<VirtualFile> var1) throws VcsException;

    protected abstract void load(ContinuationContext var1);

    protected abstract boolean wereChangesSaved();

    public abstract String getSaverName();

    protected abstract void showSavedChanges();

    protected static String getConflictRightPanelTitle() {
        return "Changes from remote";
    }

    protected static String getConflictLeftPanelTitle() {
        return "Your uncommitted changes";
    }

    protected class ShowSavedChangesNotificationListener
    implements NotificationListener {
        protected ShowSavedChangesNotificationListener() {
        }

        public void hyperlinkUpdate(Notification notification, HyperlinkEvent event) {
            if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED && event.getDescription().equals("saver")) {
                GitChangesSaver.this.showSavedChanges();
            }
        }
    }
}

