/*
 * Decompiled with CFR 0.152.
 */
package git4idea.stash;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitSimpleHandler;
import git4idea.config.GitConfigUtil;
import git4idea.repo.GitRepository;
import git4idea.ui.StashInfo;
import git4idea.util.GitUIUtil;
import git4idea.util.StringScanner;
import java.nio.charset.Charset;

public class GitStashUtils {
    private static final Logger LOG = Logger.getInstance(GitStashUtils.class);

    private GitStashUtils() {
    }

    public static boolean saveStash(Git git, GitRepository repository, String message) {
        GitCommandResult result = git.stashSave(repository, message);
        return result.success() && !result.getErrorOutputAsJoinedString().contains("No local changes to save");
    }

    public static void loadStashStack(Project project, VirtualFile root, Consumer<StashInfo> consumer) {
        GitStashUtils.loadStashStack(project, root, Charset.forName(GitConfigUtil.getLogEncoding(project, root)), consumer);
    }

    public static void loadStashStack(Project project, VirtualFile root, Charset charset, Consumer<StashInfo> consumer) {
        String out;
        GitSimpleHandler h = new GitSimpleHandler(project, root, GitCommand.STASH.readLockingCommand());
        h.setSilent(true);
        h.addParameters("list");
        try {
            h.setCharset(charset);
            out = h.run();
        }
        catch (VcsException e) {
            GitUIUtil.showOperationError(project, e, h.printableCommandLine());
            return;
        }
        StringScanner s = new StringScanner(out);
        while (s.hasMoreData()) {
            consumer.consume((Object)new StashInfo(s.boundedToken(':'), s.boundedToken(':'), s.line().trim()));
        }
    }
}

