/*
 * Decompiled with CFR 0.152.
 */
package git4idea.ui;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.TypeSafeDataProvider;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesTreeBrowser;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.table.TableView;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import git4idea.GitCommit;
import java.awt.BorderLayout;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class GitCommitListPanel
extends JPanel
implements TypeSafeDataProvider {
    private final List<GitCommit> myCommits;
    private final TableView<GitCommit> myTable;

    public GitCommitListPanel(List<GitCommit> commits, String emptyText) {
        this.myCommits = commits;
        this.myTable = new TableView();
        this.updateModel();
        this.myTable.setSelectionMode(2);
        this.myTable.setStriped(true);
        if (emptyText != null) {
            this.myTable.getEmptyText().setText(emptyText);
        }
        this.setLayout(new BorderLayout());
        this.add(ScrollPaneFactory.createScrollPane(this.myTable));
    }

    public void addListSelectionListener(final Consumer<GitCommit> listener) {
        this.myTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ListSelectionModel lsm = (ListSelectionModel)e.getSource();
                int i = lsm.getMaxSelectionIndex();
                int j = lsm.getMinSelectionIndex();
                if (i >= 0 && i == j) {
                    listener.consume(GitCommitListPanel.this.myCommits.get(i));
                }
            }
        });
    }

    public void addListMultipleSelectionListener(final Consumer<List<Change>> listener) {
        this.myTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                List commits = GitCommitListPanel.this.myTable.getSelectedObjects();
                ArrayList changes = new ArrayList();
                ListIterator iterator = commits.listIterator(commits.size());
                while (iterator.hasPrevious()) {
                    changes.addAll(((GitCommit)((Object)iterator.previous())).getChanges());
                }
                listener.consume((Object)CommittedChangesTreeBrowser.zipChanges(changes));
            }
        });
    }

    public void registerDiffAction(AnAction diffAction) {
        diffAction.registerCustomShortcutSet(CommonShortcuts.getDiff(), this.myTable);
    }

    public void calcData(DataKey key, DataSink sink) {
        if (VcsDataKeys.CHANGES.equals(key)) {
            int[] rows = this.myTable.getSelectedRows();
            if (rows.length != 1) {
                return;
            }
            int row = rows[0];
            GitCommit gitCommit = this.myCommits.get(row);
            sink.put(key, (Object)ArrayUtil.toObjectArray((Collection)gitCommit.getChanges(), Change.class));
        }
    }

    public JComponent getPreferredFocusComponent() {
        return this.myTable;
    }

    public void clearSelection() {
        this.myTable.clearSelection();
    }

    public void setCommits(List<GitCommit> commits) {
        this.myCommits.clear();
        this.myCommits.addAll(commits);
        this.updateModel();
        this.myTable.repaint();
    }

    private void updateModel() {
        this.myTable.setModelAndUpdateColumns(new ListTableModel(this.generateColumnsInfo(this.myCommits), this.myCommits, 0));
    }

    private ColumnInfo[] generateColumnsInfo(List<GitCommit> commits) {
        ItemAndWidth hash = new ItemAndWidth("", 0);
        ItemAndWidth author = new ItemAndWidth("", 0);
        ItemAndWidth time = new ItemAndWidth("", 0);
        for (GitCommit commit : commits) {
            hash = this.getMax(hash, GitCommitListPanel.getHash(commit));
            author = this.getMax(author, GitCommitListPanel.getAuthor(commit));
            time = this.getMax(time, GitCommitListPanel.getTime(commit));
        }
        return new ColumnInfo[]{new GitCommitColumnInfo("Hash", hash.myItem){

            public String valueOf(GitCommit commit) {
                return GitCommitListPanel.getHash(commit);
            }
        }, new ColumnInfo<GitCommit, String>("Subject"){

            public String valueOf(GitCommit commit) {
                return commit.getSubject();
            }
        }, new GitCommitColumnInfo("Author", author.myItem){

            public String valueOf(GitCommit commit) {
                return GitCommitListPanel.getAuthor(commit);
            }
        }, new GitCommitColumnInfo("Author time", time.myItem){

            public String valueOf(GitCommit commit) {
                return GitCommitListPanel.getTime(commit);
            }
        }};
    }

    private ItemAndWidth getMax(ItemAndWidth current, String candidate) {
        int width = this.myTable.getFontMetrics(this.myTable.getFont()).stringWidth(candidate);
        if (width > current.myWidth) {
            return new ItemAndWidth(candidate, width);
        }
        return current;
    }

    private static String getHash(GitCommit commit) {
        return DvcsUtil.getShortHash((String)commit.getId().toString());
    }

    private static String getAuthor(GitCommit commit) {
        return commit.getAuthor().getName();
    }

    private static String getTime(GitCommit commit) {
        return DateFormatUtil.formatPrettyDateTime((long)commit.getAuthorTime());
    }

    private static abstract class GitCommitColumnInfo
    extends ColumnInfo<GitCommit, String> {
        private final String myMaxString;

        public GitCommitColumnInfo(String name, String maxString) {
            super(name);
            this.myMaxString = maxString;
        }

        public String getMaxStringValue() {
            return this.myMaxString;
        }

        public int getAdditionalWidth() {
            return 10;
        }
    }

    private static class ItemAndWidth {
        private final String myItem;
        private final int myWidth;

        private ItemAndWidth(String item, int width) {
            this.myItem = item;
            this.myWidth = width;
        }
    }
}

