/*
 * Decompiled with CFR 0.152.
 */
package git4idea.ui.branch;

import com.intellij.dvcs.ui.NewBranchAction;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import git4idea.GitBranch;
import git4idea.GitLocalBranch;
import git4idea.GitRemoteBranch;
import git4idea.branch.GitBranchUtil;
import git4idea.branch.GitBrancher;
import git4idea.repo.GitRepository;
import git4idea.ui.branch.GitMultiRootBranchConfig;
import git4idea.validators.GitNewBranchNameValidator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;

class GitBranchPopupActions {
    private final Project myProject;
    private final GitRepository myRepository;

    GitBranchPopupActions(Project project, GitRepository repository) {
        this.myProject = project;
        this.myRepository = repository;
    }

    ActionGroup createActions(DefaultActionGroup toInsert) {
        DefaultActionGroup popupGroup = new DefaultActionGroup(null, false);
        popupGroup.addAction((AnAction)new GitNewBranchAction(this.myProject, Collections.singletonList(this.myRepository)));
        popupGroup.addAction((AnAction)new CheckoutRevisionActions(this.myProject, this.myRepository));
        if (toInsert != null) {
            popupGroup.addAll((ActionGroup)toInsert);
        }
        popupGroup.addSeparator("Local Branches");
        ArrayList<GitLocalBranch> localBranches = new ArrayList<GitLocalBranch>(this.myRepository.getBranches().getLocalBranches());
        Collections.sort(localBranches);
        for (GitBranch gitBranch : localBranches) {
            if (gitBranch.equals(this.myRepository.getCurrentBranch())) continue;
            popupGroup.add((AnAction)new LocalBranchActions(this.myProject, Collections.singletonList(this.myRepository), gitBranch.getName(), this.myRepository));
        }
        popupGroup.addSeparator("Remote Branches");
        ArrayList<GitRemoteBranch> remoteBranches = new ArrayList<GitRemoteBranch>(this.myRepository.getBranches().getRemoteBranches());
        Collections.sort(remoteBranches);
        for (GitBranch gitBranch : remoteBranches) {
            popupGroup.add((AnAction)new RemoteBranchActions(this.myProject, Collections.singletonList(this.myRepository), gitBranch.getName(), this.myRepository));
        }
        return popupGroup;
    }

    private static class MergeAction
    extends DumbAwareAction {
        private final Project myProject;
        private final List<GitRepository> myRepositories;
        private final String myBranchName;
        private final boolean myLocalBranch;

        public MergeAction(Project project, List<GitRepository> repositories, String branchName, boolean localBranch) {
            super("Merge");
            this.myProject = project;
            this.myRepositories = repositories;
            this.myBranchName = branchName;
            this.myLocalBranch = localBranch;
        }

        public void actionPerformed(AnActionEvent e) {
            GitBrancher brancher = (GitBrancher)ServiceManager.getService((Project)this.myProject, GitBrancher.class);
            brancher.merge(this.myBranchName, this.deleteOnMerge(), this.myRepositories);
        }

        private GitBrancher.DeleteOnMergeOption deleteOnMerge() {
            if (this.myLocalBranch && !this.myBranchName.equals("master")) {
                return GitBrancher.DeleteOnMergeOption.PROPOSE;
            }
            return GitBrancher.DeleteOnMergeOption.NOTHING;
        }
    }

    private static class CompareAction
    extends DumbAwareAction {
        private final Project myProject;
        private final List<GitRepository> myRepositories;
        private final String myBranchName;
        private final GitRepository mySelectedRepository;

        public CompareAction(Project project, List<GitRepository> repositories, String branchName, GitRepository selectedRepository) {
            super("Compare");
            this.myProject = project;
            this.myRepositories = repositories;
            this.myBranchName = branchName;
            this.mySelectedRepository = selectedRepository;
        }

        public void actionPerformed(AnActionEvent e) {
            GitBrancher brancher = (GitBrancher)ServiceManager.getService((Project)this.myProject, GitBrancher.class);
            brancher.compare(this.myBranchName, this.myRepositories, this.mySelectedRepository);
        }
    }

    static class RemoteBranchActions
    extends ActionGroup {
        private final Project myProject;
        private final List<GitRepository> myRepositories;
        private String myBranchName;
        private final GitRepository mySelectedRepository;

        RemoteBranchActions(Project project, List<GitRepository> repositories, String branchName, GitRepository selectedRepository) {
            super("", true);
            this.myProject = project;
            this.myRepositories = repositories;
            this.myBranchName = branchName;
            this.mySelectedRepository = selectedRepository;
            this.getTemplatePresentation().setText(this.myBranchName, false);
        }

        public AnAction[] getChildren(AnActionEvent e) {
            return new AnAction[]{new CheckoutRemoteBranchAction(this.myProject, this.myRepositories, this.myBranchName), new CompareAction(this.myProject, this.myRepositories, this.myBranchName, this.mySelectedRepository), new MergeAction(this.myProject, this.myRepositories, this.myBranchName, false), new RemoteDeleteAction(this.myProject, this.myRepositories, this.myBranchName)};
        }

        private static class RemoteDeleteAction
        extends DumbAwareAction {
            private final Project myProject;
            private final List<GitRepository> myRepositories;
            private final String myBranchName;

            RemoteDeleteAction(Project project, List<GitRepository> repositories, String branchName) {
                super("Delete");
                this.myProject = project;
                this.myRepositories = repositories;
                this.myBranchName = branchName;
            }

            public void actionPerformed(AnActionEvent e) {
                GitBrancher brancher = (GitBrancher)ServiceManager.getService((Project)this.myProject, GitBrancher.class);
                brancher.deleteRemoteBranch(this.myBranchName, this.myRepositories);
            }
        }

        private static class CheckoutRemoteBranchAction
        extends DumbAwareAction {
            private final Project myProject;
            private final List<GitRepository> myRepositories;
            private final String myRemoteBranchName;

            public CheckoutRemoteBranchAction(Project project, List<GitRepository> repositories, String remoteBranchName) {
                super("Checkout as new local branch");
                this.myProject = project;
                this.myRepositories = repositories;
                this.myRemoteBranchName = remoteBranchName;
            }

            public void actionPerformed(AnActionEvent e) {
                String name = Messages.showInputDialog((Project)this.myProject, (String)"Enter name of new branch", (String)"Checkout Remote Branch", (Icon)Messages.getQuestionIcon(), (String)this.guessBranchName(), (InputValidator)GitNewBranchNameValidator.newInstance(this.myRepositories));
                if (name != null) {
                    GitBrancher brancher = (GitBrancher)ServiceManager.getService((Project)this.myProject, GitBrancher.class);
                    brancher.checkoutNewBranchStartingFrom(name, this.myRemoteBranchName, this.myRepositories, null);
                }
            }

            private String guessBranchName() {
                int slashPosition = this.myRemoteBranchName.indexOf("/");
                return this.myRemoteBranchName.substring(slashPosition + 1);
            }
        }
    }

    static class LocalBranchActions
    extends ActionGroup {
        private final Project myProject;
        private final List<GitRepository> myRepositories;
        private String myBranchName;
        private final GitRepository mySelectedRepository;

        LocalBranchActions(Project project, List<GitRepository> repositories, String branchName, GitRepository selectedRepository) {
            super("", true);
            this.myProject = project;
            this.myRepositories = repositories;
            this.myBranchName = branchName;
            this.mySelectedRepository = selectedRepository;
            this.getTemplatePresentation().setText(this.calcBranchText(), false);
        }

        private String calcBranchText() {
            String trackedBranch = new GitMultiRootBranchConfig(this.myRepositories).getTrackedBranch(this.myBranchName);
            if (trackedBranch != null) {
                return this.myBranchName + " -> " + trackedBranch;
            }
            return this.myBranchName;
        }

        List<GitRepository> getRepositories() {
            return this.myRepositories;
        }

        public String getBranchName() {
            return this.myBranchName;
        }

        public AnAction[] getChildren(AnActionEvent e) {
            return new AnAction[]{new CheckoutAction(this.myProject, this.myRepositories, this.myBranchName), new CheckoutAsNewBranch(this.myProject, this.myRepositories, this.myBranchName), new CompareAction(this.myProject, this.myRepositories, this.myBranchName, this.mySelectedRepository), new MergeAction(this.myProject, this.myRepositories, this.myBranchName, true), new DeleteAction(this.myProject, this.myRepositories, this.myBranchName)};
        }

        private static class DeleteAction
        extends DumbAwareAction {
            private final Project myProject;
            private final List<GitRepository> myRepositories;
            private final String myBranchName;

            DeleteAction(Project project, List<GitRepository> repositories, String branchName) {
                super("Delete");
                this.myProject = project;
                this.myRepositories = repositories;
                this.myBranchName = branchName;
            }

            public void actionPerformed(AnActionEvent e) {
                GitBrancher brancher = (GitBrancher)ServiceManager.getService((Project)this.myProject, GitBrancher.class);
                brancher.deleteBranch(this.myBranchName, this.myRepositories);
            }
        }

        private static class CheckoutAsNewBranch
        extends DumbAwareAction {
            private final Project myProject;
            private final List<GitRepository> myRepositories;
            private final String myBranchName;

            CheckoutAsNewBranch(Project project, List<GitRepository> repositories, String branchName) {
                super("Checkout as new branch");
                this.myProject = project;
                this.myRepositories = repositories;
                this.myBranchName = branchName;
            }

            public void actionPerformed(AnActionEvent e) {
                String name = Messages.showInputDialog((Project)this.myProject, (String)"Enter name of new branch", (String)("Checkout New Branch From " + this.myBranchName), (Icon)Messages.getQuestionIcon(), (String)"", (InputValidator)GitNewBranchNameValidator.newInstance(this.myRepositories));
                if (name != null) {
                    GitBrancher brancher = (GitBrancher)ServiceManager.getService((Project)this.myProject, GitBrancher.class);
                    brancher.checkoutNewBranchStartingFrom(name, this.myBranchName, this.myRepositories, null);
                }
            }
        }

        private static class CheckoutAction
        extends DumbAwareAction {
            private final Project myProject;
            private final List<GitRepository> myRepositories;
            private final String myBranchName;

            CheckoutAction(Project project, List<GitRepository> repositories, String branchName) {
                super("Checkout");
                this.myProject = project;
                this.myRepositories = repositories;
                this.myBranchName = branchName;
            }

            public void actionPerformed(AnActionEvent e) {
                GitBrancher brancher = (GitBrancher)ServiceManager.getService((Project)this.myProject, GitBrancher.class);
                brancher.checkout(this.myBranchName, this.myRepositories, null);
            }
        }
    }

    private static class CheckoutRevisionActions
    extends DumbAwareAction {
        private final Project myProject;
        private final GitRepository myRepository;

        CheckoutRevisionActions(Project project, GitRepository repository) {
            super("Checkout Tag or Revision");
            this.myProject = project;
            this.myRepository = repository;
        }

        public void actionPerformed(AnActionEvent e) {
            String reference = Messages.showInputDialog((Project)this.myProject, (String)"Enter reference (branch, tag) name or commit hash", (String)"Checkout", (Icon)Messages.getQuestionIcon());
            if (reference != null) {
                GitBrancher brancher = (GitBrancher)ServiceManager.getService((Project)this.myProject, GitBrancher.class);
                brancher.checkout(reference, Collections.singletonList(this.myRepository), null);
            }
        }

        public void update(AnActionEvent e) {
            if (this.myRepository.isFresh()) {
                e.getPresentation().setEnabled(false);
                e.getPresentation().setDescription("Checkout is not possible before the first commit");
            }
        }
    }

    public static class GitNewBranchAction
    extends NewBranchAction<GitRepository> {
        public GitNewBranchAction(Project project, List<GitRepository> repositories) {
            super(project, repositories);
        }

        public void actionPerformed(AnActionEvent e) {
            String name = GitBranchUtil.getNewBranchNameFromUser(this.myProject, this.myRepositories, "Create New Branch");
            if (name != null) {
                GitBrancher brancher = (GitBrancher)ServiceManager.getService((Project)this.myProject, GitBrancher.class);
                brancher.checkoutNewBranch(name, this.myRepositories);
            }
        }
    }
}

