/*
 * Decompiled with CFR 0.152.
 */
package git4idea.ui.branch;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.repo.Repository;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.diff.impl.dir.FrameDialogWrapper;
import com.intellij.openapi.project.Project;
import com.intellij.ui.TabbedPaneImpl;
import git4idea.GitUtil;
import git4idea.repo.GitRepository;
import git4idea.ui.branch.GitCompareBranchesDiffPanel;
import git4idea.ui.branch.GitCompareBranchesLogPanel;
import git4idea.util.GitCommitCompareInfo;
import icons.VcsLogIcons;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class GitCompareBranchesDialog
extends FrameDialogWrapper {
    private final Project myProject;
    private final JPanel myLogPanel;
    private final TabbedPaneImpl myTabbedPane;
    private final String myTitle;
    private final FrameDialogWrapper.Mode myMode;

    public GitCompareBranchesDialog(Project project, String branchName, String currentBranchName, GitCommitCompareInfo compareInfo, GitRepository initialRepo) {
        this(project, branchName, currentBranchName, compareInfo, initialRepo, false);
    }

    public GitCompareBranchesDialog(Project project, String branchName, String currentBranchName, GitCommitCompareInfo compareInfo, GitRepository initialRepo, boolean dialog) {
        this.myProject = project;
        String rootString = compareInfo.getRepositories().size() == 1 && GitUtil.getRepositoryManager(this.myProject).moreThanOneRoot() ? " in root " + DvcsUtil.getShortRepositoryName((Repository)initialRepo) : "";
        this.myTitle = String.format("Comparing %s with %s%s", currentBranchName, branchName, rootString);
        this.myMode = dialog ? FrameDialogWrapper.Mode.MODAL : FrameDialogWrapper.Mode.FRAME;
        GitCompareBranchesDiffPanel diffPanel = new GitCompareBranchesDiffPanel(this.myProject, branchName, currentBranchName, compareInfo);
        this.myLogPanel = new GitCompareBranchesLogPanel(this.myProject, branchName, currentBranchName, compareInfo, initialRepo);
        this.myTabbedPane = new TabbedPaneImpl(1);
        this.myTabbedPane.addTab("Log", VcsLogIcons.Branch, (Component)this.myLogPanel);
        this.myTabbedPane.addTab("Diff", AllIcons.Actions.Diff, (Component)diffPanel);
        this.myTabbedPane.setKeyboardNavigation(TabbedPaneImpl.DEFAULT_PREV_NEXT_SHORTCUTS);
    }

    protected JComponent getPanel() {
        return this.myTabbedPane;
    }

    protected JComponent getPreferredFocusedComponent() {
        return this.myLogPanel;
    }

    protected String getDimensionServiceKey() {
        return GitCompareBranchesDialog.class.getName();
    }

    protected String getTitle() {
        return this.myTitle;
    }

    protected Project getProject() {
        return this.myProject;
    }

    protected FrameDialogWrapper.Mode getMode() {
        return this.myMode;
    }
}

