/*
 * Decompiled with CFR 0.152.
 */
package git4idea.update;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.util.continuation.Continuation;
import com.intellij.util.continuation.ContinuationContext;
import com.intellij.util.continuation.ContinuationPause;
import com.intellij.util.continuation.TaskDescriptor;
import com.intellij.util.continuation.Where;
import git4idea.GitPlatformFacade;
import git4idea.GitUtil;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.util.GitFreezingProcess;

public class GitComplexProcess {
    private final Project myProject;
    private final String myTitle;
    private final Operation myOperation;
    private final String myFreezeReason;
    private final GitRepositoryManager myRepositoryManager;
    private final ChangeListManager myChangeListManager;
    private final TaskDescriptor BLOCK = new TaskDescriptor("", Where.AWT){

        public void run(ContinuationContext context) {
            GitFreezingProcess.saveAndBlock((GitPlatformFacade)ServiceManager.getService((Project)GitComplexProcess.this.myProject, GitPlatformFacade.class));
        }
    };
    private final TaskDescriptor FREEZE;
    private final TaskDescriptor RELEASE = new TaskDescriptor("", Where.AWT){

        public void run(ContinuationContext context) {
            GitComplexProcess.this.myChangeListManager.letGo();
        }

        public boolean isHaveMagicCure() {
            return true;
        }
    };
    private final TaskDescriptor UNBLOCK = new TaskDescriptor("", Where.AWT){

        public void run(ContinuationContext context) {
            GitFreezingProcess.unblock((GitPlatformFacade)ServiceManager.getService((Project)GitComplexProcess.this.myProject, GitPlatformFacade.class));
        }

        public boolean isHaveMagicCure() {
            return true;
        }
    };
    private final TaskDescriptor UPDATE_REPOSITORIES;

    public static void execute(Project project, String title, Operation operation) {
        new GitComplexProcess(project, title, operation).run();
    }

    private GitComplexProcess(Project project, String title, Operation operation) {
        this.myProject = project;
        this.myTitle = title;
        this.myOperation = operation;
        this.myFreezeReason = "Local changes are not available until Git " + this.myTitle + " is finished.";
        this.myRepositoryManager = GitUtil.getRepositoryManager(this.myProject);
        this.myChangeListManager = ChangeListManager.getInstance((Project)this.myProject);
        this.FREEZE = new TaskDescriptor(this.myTitle, Where.POOLED){

            public void run(ContinuationContext context) {
                GitComplexProcess.this.myChangeListManager.freeze((ContinuationPause)context, GitComplexProcess.this.myFreezeReason);
            }
        };
        this.UPDATE_REPOSITORIES = new TaskDescriptor(this.myTitle, Where.POOLED){

            public void run(ContinuationContext context) {
                for (GitRepository repo : GitComplexProcess.this.myRepositoryManager.getRepositories()) {
                    repo.update();
                }
            }
        };
    }

    private void run() {
        Continuation continuation = Continuation.createForCurrentProgress((Project)this.myProject, (boolean)true, (String)this.myTitle);
        String taskTitle = "Git: " + this.myTitle;
        TaskDescriptor operation = new TaskDescriptor(taskTitle, Where.POOLED){

            public void run(ContinuationContext context) {
                GitComplexProcess.this.myOperation.run(context);
            }
        };
        TaskDescriptor[] tasks = new TaskDescriptor[]{this.BLOCK, this.FREEZE, operation, this.UPDATE_REPOSITORIES, this.RELEASE, this.UNBLOCK};
        continuation.run(tasks);
    }

    public static interface Operation {
        public void run(ContinuationContext var1);
    }
}

