/*
 * Decompiled with CFR 0.152.
 */
package git4idea.update;

import com.intellij.CommonBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.EmptyConsumer;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.TimedVcsCommit;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.VcsUser;
import git4idea.DialogManager;
import git4idea.history.GitHistoryUtils;
import java.util.Arrays;

public class GitRebaseOverMergeProblem {
    private static final Logger LOG = Logger.getInstance(GitRebaseOverMergeProblem.class);
    public static final String DESCRIPTION = "You are about to rebase merge commits. \nThis can lead to duplicate commits in history, or even data loss.\nIt is recommended to merge instead of rebase in this case.";

    public static boolean hasProblem(Project project, VirtualFile root, String baseRef, String currentRef) {
        final Ref mergeFound = Ref.create((Object)Boolean.FALSE);
        Consumer<TimedVcsCommit> detectingConsumer = new Consumer<TimedVcsCommit>(){

            public void consume(TimedVcsCommit commit) {
                mergeFound.set((Object)true);
            }
        };
        String range = baseRef + ".." + currentRef;
        try {
            GitHistoryUtils.readCommits(project, root, Arrays.asList(range, "--merges"), (Consumer<VcsUser>)EmptyConsumer.getInstance(), (Consumer<VcsRef>)EmptyConsumer.getInstance(), detectingConsumer);
        }
        catch (VcsException e) {
            LOG.warn("Couldn't get git log --merges " + range, (Throwable)e);
        }
        return (Boolean)mergeFound.get();
    }

    public static Decision showDialog() {
        final Ref decision = Ref.create();
        ApplicationManager.getApplication().invokeAndWait(new Runnable(){

            @Override
            public void run() {
                decision.set((Object)GitRebaseOverMergeProblem.doShowDialog());
            }
        }, ModalityState.defaultModalityState());
        return (Decision)((Object)decision.get());
    }

    private static Decision doShowDialog() {
        int decision = DialogManager.showMessage(DESCRIPTION, "Rebasing Merge Commits", Decision.getButtonTitles(), Decision.getDefaultButtonIndex(), Decision.getFocusedButtonIndex(), Messages.getWarningIcon(), null);
        return Decision.getOption(decision);
    }

    public static enum Decision {
        MERGE_INSTEAD("Merge"),
        REBASE_ANYWAY("Rebase Anyway"),
        CANCEL_OPERATION(CommonBundle.getCancelButtonText());

        private final String myButtonText;

        private Decision(String buttonText) {
            this.myButtonText = buttonText;
        }

        private static String[] getButtonTitles() {
            return (String[])ContainerUtil.map2Array((Object[])Decision.values(), String.class, (Function)new Function<Decision, String>(){

                public String fun(Decision decision) {
                    return decision.myButtonText;
                }
            });
        }

        public static Decision getOption(final int index) {
            return (Decision)((Object)ObjectUtils.assertNotNull((Object)ContainerUtil.find((Object[])Decision.values(), (Condition)new Condition<Decision>(){

                public boolean value(Decision decision) {
                    return decision.ordinal() == index;
                }
            })));
        }

        private static int getDefaultButtonIndex() {
            return MERGE_INSTEAD.ordinal();
        }

        private static int getFocusedButtonIndex() {
            return CANCEL_OPERATION.ordinal();
        }
    }
}

