/*
 * Decompiled with CFR 0.152.
 */
package git4idea.util;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FilePathImpl;
import com.intellij.openapi.vcs.changes.ui.FilePathChangesTreeList;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.util.Collection;
import java.util.List;
import javax.swing.JPanel;

public class GitSimplePathsBrowser
extends JPanel {
    public GitSimplePathsBrowser(Project project, Collection<String> absolutePaths) {
        super(new BorderLayout());
        FilePathChangesTreeList browser = GitSimplePathsBrowser.createBrowser(project, absolutePaths);
        ActionToolbar toolbar = GitSimplePathsBrowser.createToolbar(browser);
        this.add((Component)toolbar.getComponent(), "North");
        this.add((Component)browser);
    }

    private static FilePathChangesTreeList createBrowser(Project project, Collection<String> absolutePaths) {
        List<FilePath> filePaths = GitSimplePathsBrowser.toFilePaths(absolutePaths);
        FilePathChangesTreeList browser = new FilePathChangesTreeList(project, filePaths, false, false, null, null);
        browser.setChangesToDisplay(filePaths);
        return browser;
    }

    private static ActionToolbar createToolbar(FilePathChangesTreeList browser) {
        DefaultActionGroup actionGroup = new DefaultActionGroup(browser.getTreeActions());
        return ActionManager.getInstance().createActionToolbar("unknown", (ActionGroup)actionGroup, true);
    }

    private static List<FilePath> toFilePaths(Collection<String> absolutePaths) {
        return ContainerUtil.map(absolutePaths, (Function)new Function<String, FilePath>(){

            public FilePath fun(String path) {
                return new FilePathImpl(new File(path), false);
            }
        });
    }
}

