/*
 * Decompiled with CFR 0.152.
 */
package git4idea.util;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.ui.SelectFilesDialog;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import git4idea.GitUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Action;
import javax.swing.event.HyperlinkEvent;

public class UntrackedFilesNotifier {
    private UntrackedFilesNotifier() {
    }

    public static void notifyUntrackedFilesOverwrittenBy(final Project project, VirtualFile root, Collection<String> relativePaths, final String operation, String description) {
        String notificationTitle = StringUtil.capitalize((String)operation) + " failed";
        String notificationDesc = description == null ? UntrackedFilesNotifier.createUntrackedFilesOverwrittenDescription(operation, true) : description;
        final Collection<String> absolutePaths = GitUtil.toAbsolute(root, relativePaths);
        final List untrackedFiles = ContainerUtil.mapNotNull(absolutePaths, (Function)new Function<String, VirtualFile>(){

            public VirtualFile fun(String absolutePath) {
                return GitUtil.findRefreshFileOrLog(absolutePath);
            }
        });
        VcsNotifier.getInstance((Project)project).notifyError(notificationTitle, notificationDesc, new NotificationListener(){

            public void hyperlinkUpdate(Notification notification, HyperlinkEvent event) {
                if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    String dialogDesc = UntrackedFilesNotifier.createUntrackedFilesOverwrittenDescription(operation, false);
                    String title = "Untracked Files Preventing " + StringUtil.capitalize((String)operation);
                    if (untrackedFiles.isEmpty()) {
                        GitUtil.showPathsInDialog(project, absolutePaths, title, dialogDesc);
                    } else {
                        UntrackedFilesDialog dialog = new UntrackedFilesDialog(project, untrackedFiles, dialogDesc);
                        dialog.setTitle(title);
                        dialog.show();
                    }
                }
            }
        });
    }

    public static String createUntrackedFilesOverwrittenDescription(String operation, boolean addLinkToViewFiles) {
        String description1 = " untracked working tree files would be overwritten by " + operation + ".";
        String description2 = "Please move or remove them before you can " + operation + ".";
        String notificationDesc = addLinkToViewFiles ? "Some" + description1 + "<br/>" + description2 + " <a href='view'>View them</a>" : "These" + description1 + "<br/>" + description2;
        return notificationDesc;
    }

    private static class UntrackedFilesDialog
    extends SelectFilesDialog {
        public UntrackedFilesDialog(Project project, Collection<VirtualFile> untrackedFiles, String dialogDesc) {
            super(project, new ArrayList<VirtualFile>(untrackedFiles), StringUtil.stripHtml((String)dialogDesc, (boolean)true), null, false, false, true);
            this.init();
        }

        protected Action[] createActions() {
            return new Action[]{this.getOKAction()};
        }
    }
}

