/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.util.Function;
import com.intellij.util.ui.FormBuilder;
import com.jetbrains.cidr.lang.actions.newFile.DialogWrapperFacade;
import com.jetbrains.cidr.lang.actions.newFile.OCNewFileActionBase;
import com.jetbrains.cidr.lang.actions.newFile.OCNewFileHelper;
import com.jetbrains.cidr.lang.actions.newFile.OCNewFileHelperProvider;
import com.jetbrains.cidr.lang.actions.newFile.OCNewFileHelperUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Properties;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class NewNativeFileHelperProvider
implements OCNewFileHelperProvider {
    public OCNewFileHelper createHelper() {
        return new Helper();
    }

    private static class Helper
    implements OCNewFileHelper {
        private Project myProject;
        private PsiFile mySampleFile;

        private Helper() {
        }

        public boolean initFromDataContext(DataContext dataContext) {
            this.myProject = (Project)CommonDataKeys.PROJECT.getData(dataContext);
            return this.myProject != null;
        }

        public boolean initFromFile(PsiFile file) {
            this.myProject = file.getProject();
            this.mySampleFile = file;
            return true;
        }

        public String getDefaultClassPrefix() {
            return "";
        }

        public boolean canChangeDir() {
            return false;
        }

        public DialogWrapper createDialog(OCNewFileActionBase.CreateFileDialogBase peer, PsiDirectory selectedDir, DataContext dataContext) {
            return new Dialog(peer, this.mySampleFile);
        }

        public void setProperties(DialogWrapper dialog, Properties properties, PsiFile sampleFile, Project project) {
            String projectName = project.getName();
            OCNewFileHelperUtil.fillCommonTemplateProperties((Properties)properties, (String)projectName);
        }

        public void doCreateFiles(Project project, PsiDirectory directory, String[] fileNames, PsiFile[] resultElements, DialogWrapper dialog, PsiFile sampleFile) {
            Function handler = Function.NULL;
            OCNewFileHelperUtil.addCreatedFiles((PsiDirectory)directory, (String[])fileNames, (PsiFile[])resultElements, (Project)project, (Function)handler);
        }

        private static class Dialog
        extends DialogWrapper
        implements DialogWrapperFacade {
            private final OCNewFileActionBase.CreateFileDialogBase myPeer;

            public Dialog(OCNewFileActionBase.CreateFileDialogBase peer, PsiFile sampleFile) {
                super(false);
                this.myPeer = peer;
                peer.setWrapper((DialogWrapperFacade)this);
                this.setTitle(peer.getTitle());
                this.init();
            }

            protected JComponent createCenterPanel() {
                FormBuilder formBuilder = FormBuilder.createFormBuilder().setVertical(false);
                this.myPeer.fillGenericControls(formBuilder);
                this.myPeer.validateOkAction();
                JPanel myMainPanel = formBuilder.getPanel();
                JPanel result = new JPanel(new BorderLayout());
                result.add((Component)myMainPanel, "Center");
                return result;
            }

            public JComponent getPreferredFocusedComponent() {
                return this.myPeer.getPreferredFocusedComponent();
            }

            protected void doOKAction() {
                if (this.myPeer.checkCanDoOKAction()) {
                    super.doOKAction();
                }
            }

            public void setOKEnabled(boolean isEnable) {
                this.setOKActionEnabled(isEnable);
            }

            public void setErrorMessage(String text) {
                this.setErrorText(text);
            }

            protected void dispose() {
                super.dispose();
                Disposer.dispose((Disposable)this.myPeer.getDisposable());
            }
        }
    }
}

