/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.jni;

import com.android.tools.ndk.jni.JniGotoDeclarationHandler;
import com.android.tools.ndk.jni.JniNameMangler;
import com.intellij.find.findUsages.FindUsagesHandler;
import com.intellij.find.findUsages.FindUsagesHandlerFactory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.jetbrains.cidr.lang.psi.OCDeclarator;

public class JniFindUsagesHandlerFactory
extends FindUsagesHandlerFactory {
    public boolean canFindUsages(PsiElement element) {
        if (element instanceof OCDeclarator) {
            OCDeclarator declarator = (OCDeclarator)element;
            String name = declarator.getName();
            return name != null && name.startsWith("Java_");
        }
        if (element instanceof PsiMethod) {
            return ((PsiMethod)element).getModifierList().hasExplicitModifier("native");
        }
        return false;
    }

    public FindUsagesHandler createFindUsagesHandler(PsiElement element, boolean forHighlightUsages) {
        if (element instanceof OCDeclarator) {
            return JniFindUsagesHandlerFactory.findJavaReferences((OCDeclarator)element);
        }
        return JniFindUsagesHandlerFactory.findNativeReferences((PsiMethod)element);
    }

    private static FindUsagesHandler findNativeReferences(PsiMethod element) {
        PsiElement[] targets = new JniGotoDeclarationHandler().getGotoDeclarationTargets((PsiElement)element);
        if (targets != null && targets.length > 0) {
            return new MyFindUsagesHandler((PsiElement)element, targets);
        }
        return null;
    }

    private static FindUsagesHandler findJavaReferences(OCDeclarator element) {
        PsiMethod declaration = JniNameMangler.findDeclaration(element);
        if (declaration != null) {
            return new MyFindUsagesHandler((PsiElement)element, new PsiElement[]{declaration});
        }
        return null;
    }

    private static class MyFindUsagesHandler
    extends FindUsagesHandler {
        private final PsiElement[] myAdditionalElements;

        protected MyFindUsagesHandler(PsiElement element, PsiElement ... additionalElements) {
            super(element);
            this.myAdditionalElements = additionalElements;
        }

        public PsiElement[] getSecondaryElements() {
            return this.myAdditionalElements;
        }
    }
}

