/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.run;

import com.android.builder.model.NativeLibrary;
import com.android.builder.model.Variant;
import com.android.ddmlib.Client;
import com.android.ddmlib.ClientData;
import com.android.ddmlib.CollectingOutputReceiver;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.MultiLineReceiver;
import com.android.sdklib.devices.Abi;
import com.android.tools.idea.gradle.AndroidGradleModel;
import com.android.tools.ndk.MemoryRegionMap;
import com.android.tools.ndk.run.AndroidNativeExecutionStack;
import com.android.tools.ndk.run.AndroidNativeRunConfiguration;
import com.android.tools.ndk.run.AttachProgressReporter;
import com.android.tools.ndk.run.ClientShellHelper;
import com.android.tools.ndk.run.hybrid.NativeDebugProcess;
import com.android.tools.ndk.run.hybrid.StepIntoNativeBreakpointHandler;
import com.android.tools.ndk.run.hybrid.StepIntoNativeBreakpointType;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointManager;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import com.intellij.xdebugger.frame.XExecutionStack;
import com.jetbrains.cidr.execution.RunParameters;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.CidrSuspensionCause;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.LLFrame;
import com.jetbrains.cidr.execution.debugger.backend.LLThread;
import com.jetbrains.cidr.execution.debugger.breakpoints.CidrSymbolicBreakpointType;
import com.sun.jdi.Bootstrap;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.VirtualMachineManager;
import com.sun.jdi.connect.AttachingConnector;
import com.sun.jdi.connect.Connector;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.run.AndroidRunningState;

public class AndroidNativeDebugProcess
extends CidrDebugProcess
implements NativeDebugProcess {
    private static final Logger LOG = Logger.getInstance(AndroidNativeDebugProcess.class);
    private static final String LIBART_SO = "libart.so";
    private static final String ART_SIGSEGV_FAULT = "art_sigsegv_fault";
    private static final CidrSymbolicBreakpointType SYMBOLIC_BREAKPOINT_TYPE = (CidrSymbolicBreakpointType)XBreakpointType.EXTENSION_POINT_NAME.findExtension(CidrSymbolicBreakpointType.class);
    private static final String JDI_CONNECTOR_NAME = "com.sun.jdi.SocketAttach";
    private final AndroidRunningState myState;
    private final AttachNotifier myAttachNotifier;
    private final Client myClient;
    private final AttachProgressReporter myAttachProgressReporter;
    private XBreakpoint<CidrSymbolicBreakpointType.Properties> myArtSigSegvFaultBp;
    private boolean myArt = false;
    private final MemoryRegionMap myArtMemRegionMap = new MemoryRegionMap(Arrays.asList(".*\\.dex", ".*\\.odex", ".*\\.oat"));
    private final StepIntoNativeBreakpointHandler myStepIntoNativeBreakpointHandler;

    public AndroidNativeDebugProcess(RunParameters parameters, XDebugSession session, TextConsoleBuilder consoleBuilder, AndroidRunningState state, AttachNotifier attachNotifier, Client client, AttachProgressReporter attachProgressReporter) throws ExecutionException {
        super(parameters, session, consoleBuilder);
        this.myState = state;
        this.myAttachNotifier = attachNotifier;
        this.myClient = client;
        this.myAttachProgressReporter = attachProgressReporter;
        this.myStepIntoNativeBreakpointHandler = this.createStepIntoNativeHandler();
    }

    private StepIntoNativeBreakpointHandler createStepIntoNativeHandler() {
        return new StepIntoNativeBreakpointHandler(this, StepIntoNativeBreakpointType.class);
    }

    protected boolean isRemote() {
        return true;
    }

    public boolean checkCanInitBreakpoints() {
        return false;
    }

    protected void doStart(DebuggerDriver driver) throws ExecutionException {
    }

    protected void doLaunchTarget(DebuggerDriver driver) throws ExecutionException {
        this.getProcessHandler().startNotify();
        try {
            LOG.info("Loading driver");
            this.myAttachProgressReporter.step("Loading debugger driver");
            driver.loadForRemote(null);
            ClientData clientData = this.myClient.getClientData();
            LOG.info(String.format("Attaching to inferior: pid=%d, ABI=%s", clientData.getPid(), clientData.getAbi()));
            this.myAttachProgressReporter.step("Attaching to the app");
            driver.attachTo(clientData.getPid());
            this.myArt = this.isArtVM();
            if (this.myArt) {
                LOG.info("Running in ART VM");
                this.initArtSigSegvFaultBreakpoint(driver);
            } else {
                LOG.info("Running in Dalvik VM");
            }
            ApplicationManager.getApplication().runReadAction(new Runnable(){

                @Override
                public void run() {
                    AndroidNativeDebugProcess.this.getSession().initBreakpoints();
                }
            });
            LOG.info("Resuming paused inferior");
            this.myAttachProgressReporter.step("Resuming the app process");
            driver.resume();
            this.myAttachProgressReporter.step("Resuming the app VM");
            if (AndroidNativeDebugProcess.isHybridDebugModeAllowed()) {
                LOG.info("Hybrid debug mode is on, starting Java debug session: jdwp port=" + this.myClient.getDebuggerListenPort());
                this.myAttachNotifier.debugProcessAttached(this, this.myClient);
            } else {
                LOG.info("Resuming JVM: jdwp port=" + this.myClient.getDebuggerListenPort());
                this.resumeVM();
            }
            LOG.info("Launch has been completed");
        }
        catch (ExecutionException e) {
            this.myState.message("Failed to attach native debugger: " + e.getMessage(), ProcessOutputTypes.STDERR);
            throw e;
        }
        finally {
            this.myAttachProgressReporter.finish();
        }
    }

    private static boolean isHybridDebugModeAllowed() {
        return Boolean.getBoolean("hybrid.debug");
    }

    private static AttachingConnector findConnector() throws ExecutionException {
        VirtualMachineManager virtualMachineManager;
        try {
            virtualMachineManager = Bootstrap.virtualMachineManager();
        }
        catch (Error e) {
            throw new ExecutionException((Throwable)e);
        }
        for (AttachingConnector connectorObj : virtualMachineManager.attachingConnectors()) {
            Connector connector = connectorObj;
            if (!JDI_CONNECTOR_NAME.equals(connector.name())) continue;
            return (AttachingConnector)connector;
        }
        return null;
    }

    private void resumeVM() throws ExecutionException {
        Connector.Argument timeoutArg;
        Connector.Argument portArg;
        AttachingConnector jdiConnector = AndroidNativeDebugProcess.findConnector();
        if (jdiConnector == null) {
            throw new ExecutionException("Failed to find JDI connector");
        }
        Map<String, Connector.Argument> arguments = jdiConnector.defaultArguments();
        Connector.Argument hostnameArg = arguments.get("hostname");
        if (hostnameArg != null) {
            hostnameArg.setValue("localhost");
        }
        if ((portArg = arguments.get("port")) != null) {
            portArg.setValue(String.valueOf(this.myClient.getDebuggerListenPort()));
        }
        if ((timeoutArg = arguments.get("timeout")) != null) {
            timeoutArg.setValue("0");
        }
        try {
            VirtualMachine vm = jdiConnector.attach(arguments);
            vm.resume();
        }
        catch (Exception e) {
            throw new ExecutionException("Failed to resume VM", (Throwable)e);
        }
    }

    private XBreakpointManager getBreakpointManager() {
        return XDebuggerManager.getInstance((Project)this.myState.getModule().getProject()).getBreakpointManager();
    }

    private void initArtSigSegvFaultBreakpoint(DebuggerDriver driver) throws ExecutionException {
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                for (XBreakpoint bp : AndroidNativeDebugProcess.this.getBreakpointManager().getBreakpoints((XBreakpointType)SYMBOLIC_BREAKPOINT_TYPE)) {
                    CidrSymbolicBreakpointType.Properties bpProps = (CidrSymbolicBreakpointType.Properties)bp.getProperties();
                    if (!bpProps.getModuleName().equals(AndroidNativeDebugProcess.LIBART_SO) || !bpProps.getSymbolPattern().equals(AndroidNativeDebugProcess.ART_SIGSEGV_FAULT)) continue;
                    AndroidNativeDebugProcess.this.myArtSigSegvFaultBp = bp;
                    break;
                }
            }
        });
        if (this.myArtSigSegvFaultBp != null) {
            return;
        }
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                CidrSymbolicBreakpointType.Properties props = new CidrSymbolicBreakpointType.Properties(AndroidNativeDebugProcess.ART_SIGSEGV_FAULT, AndroidNativeDebugProcess.LIBART_SO);
                AndroidNativeDebugProcess.this.myArtSigSegvFaultBp = AndroidNativeDebugProcess.this.getBreakpointManager().addBreakpoint((XBreakpointType)SYMBOLIC_BREAKPOINT_TYPE, (XBreakpointProperties)props);
            }
        });
    }

    private boolean isArtVM() throws ExecutionException {
        CollectingOutputReceiver receiver = new CollectingOutputReceiver();
        this.readProcMapsFile((IShellOutputReceiver)receiver);
        return receiver.getOutput().contains(LIBART_SO);
    }

    public void stop() {
        super.stop();
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                if (AndroidNativeDebugProcess.this.myArtSigSegvFaultBp != null) {
                    XDebuggerManager.getInstance((Project)AndroidNativeDebugProcess.this.myState.getModule().getProject()).getBreakpointManager().removeBreakpoint(AndroidNativeDebugProcess.this.myArtSigSegvFaultBp);
                    AndroidNativeDebugProcess.this.myArtSigSegvFaultBp = null;
                }
            }
        });
    }

    public void handleSignal(final List<LLThread> threads, final int currentThreadIndex, final String signal, final String meaning) {
        if (!this.myArt || !signal.equals("SIGSEGV")) {
            super.handleSignal(threads, currentThreadIndex, signal, meaning);
            return;
        }
        this.postCommand(new CidrDebugProcess.DebuggerCommand(){

            public void run(DebuggerDriver driver) throws ExecutionException {
                if (!AndroidNativeDebugProcess.this.handleArtSigSegv(driver, threads, currentThreadIndex)) {
                    AndroidNativeDebugProcess.super.handleSignal(threads, currentThreadIndex, signal, meaning);
                }
            }
        });
    }

    private boolean handleArtSigSegv(DebuggerDriver driver, List<LLThread> threads, int currentThreadIndex) {
        LLThread thread = threads.get(currentThreadIndex);
        try {
            List frames = driver.getFrames(thread.getId());
            if (frames.isEmpty()) {
                return false;
            }
            LLFrame firstFrame = (LLFrame)frames.get(0);
            LOG.info(String.format("Got SIGSEGV signal, PC address: 0x%X", firstFrame.getProgramCounter()));
            MemoryRegionMap.Region region = this.myArtMemRegionMap.getRegionByAddress(firstFrame.getProgramCounter());
            if (region == null || !region.isExecutable()) {
                this.myArtMemRegionMap.clear();
                this.readProcMapsFile((IShellOutputReceiver)new MultiLineReceiver(){

                    public void processNewLines(String[] lines) {
                        AndroidNativeDebugProcess.this.myArtMemRegionMap.addMapEntries(lines);
                    }

                    public boolean isCancelled() {
                        return false;
                    }
                });
            }
            if ((region = this.myArtMemRegionMap.getRegionByAddress(firstFrame.getProgramCounter())) != null && region.isExecutable()) {
                LOG.info(String.format("SIGSEGV came from ART module '%s' - resuming the inferior", region.getFileName()));
                driver.resume();
                return true;
            }
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
        return false;
    }

    private void readProcMapsFile(IShellOutputReceiver receiver) throws ExecutionException {
        try {
            ClientShellHelper clientShell = new ClientShellHelper(this.myClient, this.myState.getPackageName());
            this.myClient.getDevice().executeShellCommand(clientShell.runAs(String.format("cat /proc/%d/maps", this.myClient.getClientData().getPid())), receiver);
        }
        catch (Exception e) {
            throw new ExecutionException((Throwable)e);
        }
    }

    public static List<File> getSymbolsDir(AndroidRunningState state, List<Abi> abis) {
        ArrayList libFolders = Lists.newArrayList();
        AndroidGradleModel androidModel = AndroidGradleModel.get((AndroidFacet)state.getFacet());
        if (androidModel != null) {
            Variant selectedVariant = androidModel.getSelectedVariant();
            Collection nativeLibraries = selectedVariant.getMainArtifact().getNativeLibraries();
            if (nativeLibraries == null) {
                return Collections.emptyList();
            }
            HashSet abiNames = Sets.newHashSetWithExpectedSize((int)abis.size());
            for (Abi abi : abis) {
                abiNames.add(abi.toString());
            }
            for (NativeLibrary library : nativeLibraries) {
                if (!abiNames.contains(library.getAbi())) continue;
                libFolders.addAll(library.getDebuggableLibraryFolders());
            }
        }
        AndroidNativeRunConfiguration config = (AndroidNativeRunConfiguration)state.getConfiguration();
        for (String symDir : config.getSymbolDirs()) {
            libFolders.add(new File(symDir));
        }
        return libFolders;
    }

    protected XExecutionStack newExecutionStack(DebuggerDriver driver, LLThread thread, boolean current, CidrSuspensionCause suspensionCause) throws ExecutionException {
        if (System.getProperty("com.google.android-studio.lazy-backtraces", "no").equals("yes")) {
            return new AndroidNativeExecutionStack(this, driver, thread, current, suspensionCause);
        }
        return super.newExecutionStack(driver, thread, current, suspensionCause);
    }

    public void handleBreakpoint(int number, List<LLThread> threads, int currentThreadIndex) {
        final XBreakpoint bp = this.myStepIntoNativeBreakpointHandler.getCodepoint(number);
        if (bp == null) {
            super.handleBreakpoint(number, threads, currentThreadIndex);
            return;
        }
        LLThread currentThread = threads.get(currentThreadIndex);
        if (((StepIntoNativeBreakpointType.Properties)bp.getProperties()).getTid() != currentThread.getId()) {
            this.getSession().resume();
            return;
        }
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                AndroidNativeDebugProcess.this.removeStepIntoNativeBreakpoint(AndroidNativeDebugProcess.this.getBreakpointManager(), (XBreakpoint<StepIntoNativeBreakpointType.Properties>)bp);
            }
        });
        this.handleXBreakpoint(threads, currentThreadIndex, bp);
    }

    private void removeStepIntoNativeBreakpoint(XBreakpointManager bpManager, XBreakpoint<StepIntoNativeBreakpointType.Properties> bp) {
        bpManager.removeBreakpoint(bp);
        this.myStepIntoNativeBreakpointHandler.unregisterBreakpoint(bp, false);
    }

    @Override
    public void registerStepIntoNativeBreakpoint(String jniMethodName, int tid) {
        final StepIntoNativeBreakpointType.Properties props = new StepIntoNativeBreakpointType.Properties(jniMethodName, tid);
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                XBreakpoint bp = AndroidNativeDebugProcess.this.getBreakpointManager().addBreakpoint((XBreakpointType)StepIntoNativeBreakpointType.INSTANCE, (XBreakpointProperties)props);
                AndroidNativeDebugProcess.this.myStepIntoNativeBreakpointHandler.registerBreakpoint(bp);
            }
        });
    }

    @Override
    public void removeAllStepIntoNativeBreakpoints() {
        final LinkedList bps = Lists.newLinkedList();
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                bps.addAll(AndroidNativeDebugProcess.this.getBreakpointManager().getBreakpoints((XBreakpointType)StepIntoNativeBreakpointType.INSTANCE));
            }
        });
        if (bps.isEmpty()) {
            return;
        }
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                XBreakpointManager bpManager = AndroidNativeDebugProcess.this.getBreakpointManager();
                for (XBreakpoint bp : bps) {
                    AndroidNativeDebugProcess.this.removeStepIntoNativeBreakpoint(bpManager, (XBreakpoint<StepIntoNativeBreakpointType.Properties>)bp);
                }
            }
        });
    }

    public static interface AttachNotifier {
        public void debugProcessAttached(AndroidNativeDebugProcess var1, Client var2);
    }
}

