/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.run;

import com.android.ddmlib.Client;
import com.android.ddmlib.CollectingOutputReceiver;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.tools.ndk.NdkHelper;
import com.android.tools.ndk.run.AndroidNativeDebugProcess;
import com.android.tools.ndk.run.AndroidNativeRunConfiguration;
import com.android.tools.ndk.run.AttachProgressReporter;
import com.android.tools.ndk.run.DebuggerContext;
import com.android.tools.ndk.run.hybrid.AndroidJavaDebugProcess;
import com.intellij.debugger.DebugEnvironment;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.DefaultDebugUIEnvironment;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.ui.tree.render.BatchEvaluator;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.RemoteConnection;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugProcessStarter;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.jetbrains.cidr.execution.CidrCommandLineState;
import com.jetbrains.cidr.execution.CidrRunner;
import com.jetbrains.cidr.execution.Installer;
import com.jetbrains.cidr.execution.RunParameters;
import com.jetbrains.cidr.execution.TrivialInstaller;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriverConfiguration;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.android.run.AndroidDebugState;
import org.jetbrains.android.run.AndroidProcessText;
import org.jetbrains.android.run.AndroidRunningState;
import org.jetbrains.android.run.AndroidRunningStateListener;
import org.jetbrains.android.run.DebugLauncher;

public class AndroidNativeDebugRunner
extends CidrRunner {
    private static final Logger LOG = Logger.getInstance(AndroidNativeDebugRunner.class);

    public String getRunnerId() {
        return "AndroidNativeDebugRunner";
    }

    protected RunContentDescriptor doExecute(RunProfileState state, ExecutionEnvironment environment) throws ExecutionException {
        AndroidRunningState runningState = (AndroidRunningState)state;
        DebuggerContext debuggerContext = ((AndroidNativeRunConfiguration)runningState.getConfiguration()).getDebuggerContext();
        NativeDebugLauncher launcher = new NativeDebugLauncher(runningState, environment, debuggerContext);
        runningState.setDebugMode(true);
        runningState.setDebugLauncher((DebugLauncher)launcher);
        runningState.addListener(new AndroidRunningStateListener(){

            public void executionFailed() {
                LOG.error("Android Launch failed");
            }
        });
        RunContentDescriptor runDescriptor = super.doExecute(state, environment);
        if (runDescriptor != null) {
            launcher.setRunDescriptor(runDescriptor);
        }
        return runDescriptor;
    }

    public boolean canRun(String executorId, RunProfile profile) {
        return (DefaultDebugExecutor.EXECUTOR_ID.equals(executorId) || DefaultRunExecutor.EXECUTOR_ID.equals(executorId)) && profile instanceof AndroidNativeRunConfiguration;
    }

    private class NativeDebugLauncher
    implements DebugLauncher,
    AndroidNativeDebugProcess.AttachNotifier {
        private final AndroidRunningState myRunningState;
        private final ExecutionEnvironment myEnvironment;
        private RunContentDescriptor myRunDescriptor;
        private DebuggerContext myDebuggerContext;
        private AtomicBoolean myCancelled = new AtomicBoolean(false);

        public NativeDebugLauncher(AndroidRunningState runningState, ExecutionEnvironment environment, DebuggerContext debuggerContext) {
            this.myRunningState = runningState;
            this.myEnvironment = environment;
            this.myDebuggerContext = debuggerContext;
        }

        public void launchDebug(final Client client) {
            ((AndroidNativeRunConfiguration)this.myRunningState.getConfiguration()).onLaunchDebug(client);
            IDevice device = client.getDevice();
            LOG.info(String.format("Launching native debug session on device: manufacturer=%s, model=%s, API=%s, ABIs=%s", device.getProperty("ro.product.manufacturer"), device.getProperty("ro.product.model"), device.getProperty("ro.build.version.sdk"), device.getAbis().toString()));
            this.myDebuggerContext.setAttachProgressReporter(new AttachProgressReporter(this.myRunningState.getModule().getProject()));
            try {
                this.myDebuggerContext.startServer(this.myRunningState, client, this.myCancelled);
            }
            catch (Throwable e) {
                this.onLaunchFailure(client, "Error while launching debug server on device: " + e.toString(), e);
                return;
            }
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        NativeDebugLauncher.this.launchCidrDebugger(client);
                    }
                    catch (Throwable e) {
                        NativeDebugLauncher.this.onLaunchFailure(client, "Error while starting native debug session: " + e.toString(), e);
                    }
                }
            });
        }

        private void launchCidrDebugger(final Client client) throws ExecutionException {
            XDebugSessionImpl xDebugSession;
            final IDevice device = client.getDevice();
            final RunParameters runParameters = new RunParameters(){

                public Installer getInstaller() {
                    return new TrivialInstaller(new GeneralCommandLine());
                }

                public DebuggerDriverConfiguration getDebuggerDriverConfiguration() {
                    return NativeDebugLauncher.this.myDebuggerContext.getDebuggerDriverConfiguration(NativeDebugLauncher.this.myRunningState, device);
                }

                public boolean isWaitFor() {
                    return false;
                }

                public String getArchitectureId() {
                    return NdkHelper.getArchitectureId(NdkHelper.getAbi(device));
                }
            };
            CidrCommandLineState cidrState = new CidrCommandLineState(this.myEnvironment){

                public XDebugProcess startDebugProcess(XDebugSession session) throws ExecutionException {
                    AndroidNativeDebugProcess result = new AndroidNativeDebugProcess(runParameters, session, this.getConsoleBuilder(), NativeDebugLauncher.this.myRunningState, NativeDebugLauncher.this, client, NativeDebugLauncher.this.myDebuggerContext.getAttachProgressReporter());
                    ProcessTerminatedListener.attach((ProcessHandler)result.getProcessHandler(), (Project)NativeDebugLauncher.this.myEnvironment.getProject());
                    result.start();
                    return result;
                }

                protected ProcessHandler startProcess() throws ExecutionException {
                    throw new RuntimeException("start process not implemented");
                }
            };
            this.myRunningState.message("Now Launching Native Debug Session", ProcessOutputTypes.STDOUT);
            this.myDebuggerContext.getAttachProgressReporter().step("Launching debug session");
            ProcessHandler processHandler = this.myRunningState.getProcessHandler();
            processHandler.detachProcess();
            ExecutionEnvironment env = new ExecutionEnvironmentBuilder(this.myEnvironment).executor(this.myEnvironment.getExecutor()).runner((ProgramRunner)AndroidNativeDebugRunner.this).contentToReuse(this.myRunDescriptor).build();
            try {
                xDebugSession = (XDebugSessionImpl)AndroidNativeDebugRunner.this.startDebugSession(cidrState, env, false, new XDebugSessionListener[0]);
            }
            catch (Exception e) {
                throw new ExecutionException((Throwable)e);
            }
            xDebugSession.showSessionTab();
            ProcessHandler newProcessHandler = xDebugSession.getRunContentDescriptor().getProcessHandler();
            if (newProcessHandler == null) {
                throw new ExecutionException("Cannot start debugging - null process handler.");
            }
            this.myRunningState.setProcessHandler(newProcessHandler);
            AndroidProcessText oldText = AndroidProcessText.get((ProcessHandler)processHandler);
            if (oldText != null) {
                oldText.printTo(newProcessHandler);
            }
            AndroidProcessText.attach((ProcessHandler)newProcessHandler);
        }

        private void onLaunchFailure(Client client, String message, Throwable e) {
            this.myRunningState.message(message, ProcessOutputTypes.STDERR);
            LOG.error(message, e);
            this.myCancelled.set(true);
            this.myDebuggerContext.getAttachProgressReporter().finish();
            this.forceStopActivity(client);
        }

        private void forceStopActivity(Client client) {
            String packageName = this.myRunningState.getPackageName();
            try {
                IDevice device = client.getDevice();
                CollectingOutputReceiver receiver = new CollectingOutputReceiver();
                device.executeShellCommand("am force-stop " + packageName, (IShellOutputReceiver)receiver);
            }
            catch (Exception e) {
                LOG.error("Failed to force-stop activity " + packageName, (Throwable)e);
            }
        }

        public void setRunDescriptor(RunContentDescriptor runDescriptor) {
            this.myRunDescriptor = runDescriptor;
        }

        private void startJavaDebugSession(AndroidNativeDebugProcess nativeDebugProcess, Client client) {
            ProcessHandler newProcessHandler;
            IDevice device = client.getDevice();
            String debugPort = Integer.toString(client.getDebuggerListenPort());
            Project project = this.myRunningState.getModule().getProject();
            AndroidDebugState st = new AndroidDebugState(project, new RemoteConnection(true, "localhost", debugPort, false), this.myRunningState, device);
            RunContentDescriptor debugDescriptor = null;
            try {
                debugDescriptor = this.attachVirtualMachine(nativeDebugProcess, new ExecutionEnvironmentBuilder(this.myEnvironment).executor(this.myEnvironment.getExecutor()).runner((ProgramRunner)AndroidNativeDebugRunner.this).contentToReuse(this.myRunDescriptor).build(), (RunProfileState)st, st.getRemoteConnection(), false);
            }
            catch (ExecutionException e) {
                this.myRunningState.message("ExecutionException: " + e.getMessage() + '.', ProcessOutputTypes.STDERR);
            }
            ProcessHandler processHandler = newProcessHandler = debugDescriptor != null ? debugDescriptor.getProcessHandler() : null;
            if (debugDescriptor == null || newProcessHandler == null) {
                LOG.info("cannot start debugging");
                return;
            }
            AndroidProcessText.attach((ProcessHandler)newProcessHandler);
        }

        public RunContentDescriptor attachVirtualMachine(final AndroidNativeDebugProcess nativeDebugProcess, ExecutionEnvironment environment, RunProfileState state, RemoteConnection remoteConnection, boolean pollConnection) throws ExecutionException {
            DefaultDebugUIEnvironment debugUIEnvironment = new DefaultDebugUIEnvironment(environment, state, remoteConnection, pollConnection);
            Project project = this.myRunningState.getModule().getProject();
            DebugEnvironment modelEnvironment = debugUIEnvironment.getEnvironment();
            final DebuggerSession debuggerSession = DebuggerManagerEx.getInstanceEx((Project)project).attachVirtualMachine(modelEnvironment);
            if (debuggerSession == null) {
                return null;
            }
            DebugProcessImpl debugProcess = debuggerSession.getProcess();
            if (debugProcess.isDetached() || debugProcess.isDetaching()) {
                debuggerSession.dispose();
                return null;
            }
            if (modelEnvironment.isRemote()) {
                debugProcess.putUserData(BatchEvaluator.REMOTE_SESSION_KEY, (Object)Boolean.TRUE);
            }
            XDebugSession debugSession = XDebuggerManager.getInstance((Project)project).startSessionAndShowTab(modelEnvironment.getSessionName() + "-java", debugUIEnvironment.getReuseContent(), new XDebugProcessStarter(){

                public XDebugProcess start(XDebugSession session) {
                    return AndroidJavaDebugProcess.create(session, debuggerSession, nativeDebugProcess);
                }
            });
            return debugSession.getRunContentDescriptor();
        }

        @Override
        public void debugProcessAttached(final AndroidNativeDebugProcess nativeDebugProcess, final Client client) {
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    NativeDebugLauncher.this.startJavaDebugSession(nativeDebugProcess, client);
                }
            });
        }
    }
}

