/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.run;

import com.android.tools.ndk.run.AndroidNativeDebugProcess;
import com.intellij.execution.ExecutionException;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.util.Comparing;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.frame.XExecutionStack;
import com.intellij.xdebugger.frame.XStackFrame;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.CidrErrorStackFrame;
import com.jetbrains.cidr.execution.debugger.CidrStackFrame;
import com.jetbrains.cidr.execution.debugger.CidrSuspensionCause;
import com.jetbrains.cidr.execution.debugger.backend.DBCannotCollectFramesException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.LLFrame;
import com.jetbrains.cidr.execution.debugger.backend.LLThread;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;

class AndroidNativeExecutionStack
extends XExecutionStack {
    private final AndroidNativeDebugProcess myProcess;
    private final LLThread myThread;
    private List<XStackFrame> myFrames = null;
    private volatile XStackFrame myTopFrame = null;
    private volatile boolean myTopFrameReady = false;
    private boolean myErrorCollectingFrames = false;
    private final CidrSuspensionCause mySuspensionCause;

    public AndroidNativeExecutionStack(AndroidNativeDebugProcess process, DebuggerDriver driver, LLThread thread, boolean current, CidrSuspensionCause suspensionCause) throws ExecutionException {
        super(thread.getDisplayName(), current ? AllIcons.Debugger.ThreadCurrent : AllIcons.Debugger.ThreadSuspended);
        this.myProcess = process;
        this.myThread = thread;
        this.mySuspensionCause = suspensionCause;
        if (!current) {
            return;
        }
        this.myFrames = this.getStackFrames(driver, true);
    }

    public XStackFrame getTopFrame() {
        assert (this.myTopFrameReady);
        return this.myTopFrame;
    }

    private void addStackFrames(List<XStackFrame> frames, int from, XExecutionStack.XStackFrameContainer container) {
        if (from < frames.size()) {
            container.addStackFrames(frames.subList(from, frames.size()), false);
        }
    }

    private List<XStackFrame> getStackFrames(DebuggerDriver driver, boolean untilValidLineEntry) throws ExecutionException {
        ArrayList<XStackFrame> xFrames = new ArrayList<XStackFrame>();
        try {
            List llFrames = driver.getFrames(this.myThread.getId(), untilValidLineEntry);
            CidrStackFrame prev = null;
            for (LLFrame each : ContainerUtil.reverse((List)llFrames)) {
                CidrStackFrame frame = new CidrStackFrame((CidrDebugProcess)this.myProcess, this.myThread.getId(), each, prev, this.mySuspensionCause);
                xFrames.add((XStackFrame)frame);
                prev = frame;
            }
            Collections.reverse(xFrames);
        }
        catch (DBCannotCollectFramesException e) {
            xFrames.add((XStackFrame)new CidrErrorStackFrame(e.getMessage()));
            this.myErrorCollectingFrames = true;
        }
        if (!this.myTopFrameReady) {
            if (!xFrames.isEmpty()) {
                this.myTopFrame = (XStackFrame)xFrames.get(0);
            }
            this.myTopFrameReady = true;
        }
        return xFrames;
    }

    public void computeStackFrames(final int from, final XExecutionStack.XStackFrameContainer container) {
        int sentFrames;
        int n = sentFrames = this.myFrames != null ? this.myFrames.size() : 0;
        if (sentFrames > 0) {
            this.addStackFrames(this.myFrames, from, container);
        }
        if (this.myErrorCollectingFrames) {
            container.addStackFrames(Collections.emptyList(), true);
            return;
        }
        this.myProcess.postCommand(new CidrDebugProcess.DebuggerCommand(){

            public void run(DebuggerDriver driver) throws ExecutionException {
                List newFrames = AndroidNativeExecutionStack.this.getStackFrames(driver, false);
                AndroidNativeExecutionStack.this.addStackFrames(newFrames, Math.max(from, sentFrames), container);
                container.addStackFrames(Collections.emptyList(), true);
            }
        });
    }

    public GutterIconRenderer getExecutionLineIconRenderer() {
        if (this.mySuspensionCause == null) {
            return super.getExecutionLineIconRenderer();
        }
        return new GutterIconRenderer(){

            public Icon getIcon() {
                return ((AndroidNativeExecutionStack)AndroidNativeExecutionStack.this).mySuspensionCause.icon;
            }

            public String getTooltipText() {
                return AndroidNativeExecutionStack.this.mySuspensionCause.getDisplayString();
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                    return false;
                }
                return Comparing.equal((Object)AndroidNativeExecutionStack.this.mySuspensionCause, (Object)((AndroidNativeExecutionStack)((Object)o)).mySuspensionCause);
            }

            public int hashCode() {
                return AndroidNativeExecutionStack.this.mySuspensionCause.hashCode();
            }
        };
    }

    public String toString() {
        return this.myThread.toString();
    }
}

