/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.run;

import com.android.builder.model.BuildType;
import com.android.builder.model.BuildTypeContainer;
import com.android.builder.model.Variant;
import com.android.ddmlib.Client;
import com.android.tools.idea.gradle.AndroidGradleModel;
import com.android.tools.idea.gradle.util.Projects;
import com.android.tools.ndk.run.AndroidNativeRunConfigurationEditor;
import com.android.tools.ndk.run.DebuggerContext;
import com.android.tools.ndk.run.lldb.AndroidLLDBDebuggerContext;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.ui.ConfigurationModuleSelector;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizer;
import com.intellij.openapi.util.WriteExternalException;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.run.AndroidRunConfiguration;
import org.jetbrains.android.run.ApplicationRunParameters;
import org.jetbrains.android.run.ConfigurationSpecificEditor;

public class AndroidNativeRunConfiguration
extends AndroidRunConfiguration {
    private static final String SYMBOL_DIRS = "symbol_dirs";
    private static final String SYMBOL_PATH = "symbol_path";
    private List<String> mySymbolDirs = Lists.newLinkedList();
    public String WORKING_DIR = "";
    public String TARGET_LOGGING_CHANNELS = "lldb process:gdb-remote packets";
    private final DebuggerContext myDebugContext;

    protected AndroidNativeRunConfiguration(Project project, ConfigurationFactory factory, DebuggerContext debuggerContext) {
        super(project, factory);
        this.myDebugContext = debuggerContext;
    }

    public AndroidNativeRunConfiguration(Project project, ConfigurationFactory factory) {
        this(project, factory, new AndroidLLDBDebuggerContext());
    }

    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        Project project = this.getProject();
        AndroidNativeRunConfigurationEditor editor = new AndroidNativeRunConfigurationEditor(project, (Predicate<AndroidFacet>)Predicates.alwaysFalse());
        editor.setConfigurationSpecificEditor((ConfigurationSpecificEditor)new AndroidNativeApplicationRunParameters(project, editor.getModuleSelector()));
        return editor;
    }

    public DebuggerContext getDebuggerContext() {
        return this.myDebugContext;
    }

    public boolean usesSimpleLauncher() {
        return false;
    }

    protected boolean supportMultipleDevices() {
        return false;
    }

    protected void checkConfiguration(AndroidFacet facet) throws RuntimeConfigurationException {
        super.checkConfiguration(facet);
        AndroidGradleModel androidModel = AndroidGradleModel.get((AndroidFacet)facet);
        if (androidModel != null && Projects.isBuildWithGradle((Module)facet.getModule())) {
            Variant selectedVariant = androidModel.getSelectedVariant();
            BuildTypeContainer buildTypeContainer = androidModel.findBuildType(selectedVariant.getBuildType());
            if (buildTypeContainer == null) {
                throw new RuntimeConfigurationError("Build type " + selectedVariant.getBuildType() + " not found");
            }
            BuildType buildType = buildTypeContainer.getBuildType();
            if (!buildType.isDebuggable()) {
                throw new RuntimeConfigurationError("Build type isn't debuggable");
            }
            if (!buildType.isJniDebuggable()) {
                throw new RuntimeConfigurationError("Build type isn't JNI debuggable");
            }
        } else {
            Manifest manifest = facet.getManifest();
            if (manifest == null) {
                throw new RuntimeConfigurationError("Manifest is not found");
            }
            if (!Boolean.valueOf((String)manifest.getApplication().getDebuggable().getValue()).booleanValue()) {
                throw new RuntimeConfigurationError("Application is not debuggable");
            }
        }
    }

    protected void onLaunchDebug(Client client) {
    }

    public List<String> getSymbolDirs() {
        return this.mySymbolDirs;
    }

    public void setSymbolDirs(List<String> symDirs) {
        this.mySymbolDirs.clear();
        this.mySymbolDirs.addAll(symDirs);
    }

    public void addSymbolDir(String symDir) {
        if (this.mySymbolDirs.indexOf(symDir) == -1) {
            this.mySymbolDirs.add(symDir);
        }
    }

    public String getWorkingDir() {
        return this.WORKING_DIR;
    }

    public void setWorkingDir(String workingDir) {
        this.WORKING_DIR = workingDir;
    }

    public String getTargetLoggingChannels() {
        return this.TARGET_LOGGING_CHANNELS;
    }

    public void setTargetLoggingChannels(String targetLoggingChannels) {
        this.TARGET_LOGGING_CHANNELS = targetLoggingChannels;
    }

    public void readExternal(Element element) throws InvalidDataException {
        super.readExternal(element);
        this.mySymbolDirs = JDOMExternalizer.loadStringsList((Element)element, (String)SYMBOL_DIRS, (String)SYMBOL_PATH);
    }

    public void writeExternal(Element element) throws WriteExternalException {
        super.writeExternal(element);
        JDOMExternalizer.saveStringsList((Element)element, (String)SYMBOL_DIRS, (String)SYMBOL_PATH, (String[])this.mySymbolDirs.toArray(new String[0]));
    }

    private static class AndroidNativeApplicationRunParameters
    extends ApplicationRunParameters<AndroidNativeRunConfiguration> {
        public AndroidNativeApplicationRunParameters(Project project, ConfigurationModuleSelector moduleSelector) {
            super(project, moduleSelector);
        }
    }
}

