/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.run.hybrid;

import com.android.tools.ndk.jni.JniNameMangler;
import com.android.tools.ndk.run.hybrid.NativeDebugProcess;
import com.google.common.collect.Lists;
import com.intellij.debugger.engine.JavaDebugProcess;
import com.intellij.debugger.engine.JavaValue;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaParserFacade;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.concurrency.FutureResult;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionAdapter;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XValue;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Future;

public class AndroidJavaDebugProcess
extends JavaDebugProcess {
    private static final Logger LOG = Logger.getInstance(AndroidJavaDebugProcess.class);
    private static final String TID_EXPRESSION = "android.os.Process.myTid()";
    private final DebuggerSession myJavaSession;
    private final Project myProject;
    private final NativeDebugProcess myNativeDebugProcess;
    private XSourcePosition myPauseSourcePosition;
    private Future<Integer> myCurrentTidFuture;

    public static JavaDebugProcess create(XDebugSession session, DebuggerSession javaSession, NativeDebugProcess nativeDebugProcess) {
        AndroidJavaDebugProcess res = new AndroidJavaDebugProcess(session, javaSession, nativeDebugProcess);
        javaSession.getProcess().setXDebugProcess((JavaDebugProcess)res);
        return res;
    }

    protected AndroidJavaDebugProcess(XDebugSession session, DebuggerSession javaSession, NativeDebugProcess nativeDebugProcess) {
        super(session, javaSession);
        this.myJavaSession = javaSession;
        this.myNativeDebugProcess = nativeDebugProcess;
        this.myProject = javaSession.getProject();
        session.addSessionListener((XDebugSessionListener)new XDebugSessionAdapter(){

            public void sessionPaused() {
                AndroidJavaDebugProcess.this.updateSourcePosition();
            }

            public void stackFrameChanged() {
                AndroidJavaDebugProcess.this.updateSourcePosition();
            }
        });
    }

    private Future<Integer> getCurrentThreadIdFuture(XSourcePosition sourcePosition) {
        final FutureResult futureResult = new FutureResult();
        XDebuggerEvaluator.XEvaluationCallback evaluationCallback = new XDebuggerEvaluator.XEvaluationCallback(){

            public void evaluated(XValue result) {
                if (result instanceof JavaValue) {
                    JavaValue jValue = (JavaValue)result;
                    futureResult.set((Object)Integer.parseInt(jValue.getDescriptor().getValue().toString()));
                } else {
                    futureResult.setException((Throwable)new EvaluateException("Unexpected value type: " + result.toString()));
                }
            }

            public void errorOccurred(String errorMessage) {
                futureResult.setException((Throwable)new EvaluateException("Evaluation failed: " + errorMessage));
            }
        };
        this.getEvaluator().evaluate(TID_EXPRESSION, evaluationCallback, sourcePosition);
        return futureResult;
    }

    void updateSourcePosition() {
        XStackFrame frame;
        if (this.myCurrentTidFuture != null) {
            this.myCurrentTidFuture.cancel(true);
            this.myCurrentTidFuture = null;
        }
        if ((frame = this.getSession().getCurrentStackFrame()) != null) {
            this.myPauseSourcePosition = frame.getSourcePosition();
            this.myCurrentTidFuture = this.getCurrentThreadIdFuture(this.myPauseSourcePosition);
        } else {
            this.myPauseSourcePosition = null;
        }
    }

    private void setupNativeBreakpoints(int tid) {
        final LinkedList jniMethodNames = Lists.newLinkedList();
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                List methodNames = AndroidJavaDebugProcess.this.findNativeMethodsInCurrentSourcePosition();
                if (methodNames != null) {
                    jniMethodNames.addAll(methodNames);
                }
            }
        });
        for (String jniMethodName : jniMethodNames) {
            this.myNativeDebugProcess.registerStepIntoNativeBreakpoint(jniMethodName, tid);
        }
    }

    private List<String> findNativeMethodsInCurrentSourcePosition() {
        Document document = FileDocumentManager.getInstance().getDocument(this.myPauseSourcePosition.getFile());
        if (document == null) {
            return null;
        }
        int lineEndOffset = document.getLineEndOffset(this.myPauseSourcePosition.getLine());
        String currentStatement = document.getText(new TextRange(this.myPauseSourcePosition.getOffset(), lineEndOffset)).trim();
        PsiJavaParserFacade parserFacade = JavaPsiFacade.getInstance((Project)this.myProject).getParserFacade();
        PsiElement elementAtCursor = DebuggerUtilsEx.findElementAt((PsiFile)PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(document), (int)this.myPauseSourcePosition.getOffset());
        try {
            LinkedList jniMethodNames = Lists.newLinkedList();
            PsiStatement psiStatement = parserFacade.createStatementFromText(currentStatement, elementAtCursor);
            Collection callExprs = PsiTreeUtil.findChildrenOfType((PsiElement)psiStatement, PsiMethodCallExpression.class);
            for (PsiMethodCallExpression callExpr : callExprs) {
                PsiMethod psiMethod = callExpr.resolveMethod();
                if (psiMethod == null || !psiMethod.getModifierList().hasExplicitModifier("native")) continue;
                jniMethodNames.add(JniNameMangler.getJniMethodName(psiMethod));
            }
            return jniMethodNames;
        }
        catch (IncorrectOperationException e) {
            return null;
        }
    }

    private void initNativeSteppingInto() {
        if (this.myPauseSourcePosition == null || this.myCurrentTidFuture == null) {
            return;
        }
        try {
            int currentTid = this.myCurrentTidFuture.get();
            this.setupNativeBreakpoints(currentTid);
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }

    private void removeAllStepIntoNativeMethodBreakpoints() {
        this.myNativeDebugProcess.removeAllStepIntoNativeBreakpoints();
    }

    public void startStepInto() {
        this.initNativeSteppingInto();
        super.startStepInto();
    }

    public void startForceStepInto() {
        this.initNativeSteppingInto();
        super.startForceStepInto();
    }

    public void startStepOver() {
        this.removeAllStepIntoNativeMethodBreakpoints();
        super.startStepOver();
    }

    public void runToPosition(XSourcePosition position) {
        this.removeAllStepIntoNativeMethodBreakpoints();
        super.runToPosition(position);
    }

    public void resume() {
        this.removeAllStepIntoNativeMethodBreakpoints();
        super.resume();
    }

    public void stop() {
        super.stop();
        this.myNativeDebugProcess.getSession().stop();
    }
}

