/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.run.hybrid;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import com.intellij.xdebugger.breakpoints.ui.XBreakpointCustomPropertiesPanel;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import javax.swing.Icon;
import javax.swing.JComponent;

public class StepIntoNativeBreakpointType
extends XBreakpointType<XBreakpoint<Properties>, Properties> {
    public static final StepIntoNativeBreakpointType INSTANCE = new StepIntoNativeBreakpointType();

    public StepIntoNativeBreakpointType() {
        this("StepIntoNativeBreakpointType", "StepInto Native Breakpoints");
    }

    protected StepIntoNativeBreakpointType(String id, String title) {
        super(id, title);
    }

    public String getDisplayText(XBreakpoint<Properties> breakpoint) {
        Properties properties = (Properties)breakpoint.getProperties();
        if (properties == null) {
            return "Invalid breakpoint";
        }
        return StringUtil.isEmpty((String)properties.getSymbolPattern()) ? "<Empty>" : properties.getSymbolPattern();
    }

    public Icon getEnabledIcon() {
        return AllIcons.Debugger.Db_method_breakpoint;
    }

    public Icon getDisabledIcon() {
        return AllIcons.Debugger.Db_disabled_method_breakpoint;
    }

    public Icon getInactiveDependentIcon() {
        return AllIcons.Debugger.Db_dep_method_breakpoint;
    }

    public boolean isAddBreakpointButtonVisible() {
        return false;
    }

    public Properties createProperties() {
        return new Properties();
    }

    public XBreakpoint<Properties> addBreakpoint(final Project project, JComponent parentComponent) {
        return (XBreakpoint)ApplicationManager.getApplication().runWriteAction((Computable)new Computable<XBreakpoint<Properties>>(){

            public XBreakpoint<Properties> compute() {
                return XDebuggerManager.getInstance((Project)project).getBreakpointManager().addBreakpoint((XBreakpointType)StepIntoNativeBreakpointType.this, (XBreakpointProperties)new Properties());
            }
        });
    }

    public XBreakpointCustomPropertiesPanel<XBreakpoint<Properties>> createCustomTopPropertiesPanel(Project project) {
        return null;
    }

    public XDebuggerEditorsProvider getEditorsProvider(XBreakpoint<Properties> breakpoint, Project project) {
        return null;
    }

    public static class Properties
    extends XBreakpointProperties<Properties> {
        private String mySymbolPattern;
        private int myTid = -1;

        public Properties() {
        }

        public Properties(String symbolPattern, int tid) {
            this.mySymbolPattern = symbolPattern;
            this.myTid = tid;
        }

        public String getSymbolPattern() {
            return this.mySymbolPattern;
        }

        public int getTid() {
            return this.myTid;
        }

        public Properties getState() {
            return this;
        }

        public void loadState(Properties state) {
            this.mySymbolPattern = state.mySymbolPattern;
            this.myTid = state.myTid;
        }
    }
}

