/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.run.lldb;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.Client;
import com.android.ddmlib.CollectingOutputReceiver;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.SyncException;
import com.android.ddmlib.SyncService;
import com.android.ddmlib.TimeoutException;
import com.android.sdklib.devices.Abi;
import com.android.tools.ndk.ModulePathManager;
import com.android.tools.ndk.run.AndroidNativeDebugProcess;
import com.android.tools.ndk.run.AndroidNativeRunConfiguration;
import com.android.tools.ndk.run.ClientShellHelper;
import com.android.tools.ndk.run.DebuggerContext;
import com.android.tools.ndk.run.lldb.AndroidLLDBDriverConfiguration;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriverConfiguration;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.android.run.AndroidRunningState;
import org.jetbrains.android.util.AndroidOutputReceiver;

public class AndroidLLDBDebuggerContext
extends DebuggerContext {
    private static final String LLDB_SERVER_START_SCRIPT = "start_lldb_server.sh";
    private static final String LLDB_SERVER = "lldb-server";
    private static final String DEVICE_TEMP_PATH = "/data/local/tmp";
    private static final Map<Abi, Abi> ABI_MAPPINGS = Collections.singletonMap(Abi.ARMEABI_V7A, Abi.ARMEABI);
    private static final int PLATFORM_GETPORT_NUM_RETRIES = 10;
    private static final int PLATFORM_GETPORT_TIMEOUT_MSECS = 1000;
    private int myPlatformPort = 0;
    private static final Logger LOG = Logger.getInstance(AndroidLLDBDebuggerContext.class);

    @Override
    public DebuggerDriverConfiguration getDebuggerDriverConfiguration(AndroidRunningState androidRunningState, IDevice device) {
        return new AndroidLLDBDriverConfiguration(androidRunningState, device, this.myPlatformPort, null);
    }

    @Override
    public void startServer(AndroidRunningState state, Client client, AtomicBoolean cancelled) throws DebuggerContext.StartServerException {
        try {
            this.launchLLDBServer(state, client, cancelled);
        }
        catch (Exception e) {
            throw new DebuggerContext.StartServerException(e);
        }
    }

    private void launchLLDBServer(final AndroidRunningState state, Client client, final AtomicBoolean cancelled) throws IOException, AdbCommandRejectedException, TimeoutException, SyncException, ShellCommandUnresponsiveException {
        final IDevice device = client.getDevice();
        AndroidNativeRunConfiguration configuration = (AndroidNativeRunConfiguration)state.getConfiguration();
        File lldbServer = AndroidLLDBDebuggerContext.findLLDBServer(state, device);
        if (lldbServer == null) {
            LOG.error("LLDB server not found");
            throw new IllegalStateException("LLDB server not found");
        }
        ClientShellHelper clientShell = new ClientShellHelper(client, state.getPackageName());
        String packageLLDBDir = clientShell.getPackageFolder() + "/lldb";
        String packageLLDBBinDir = packageLLDBDir + "/bin";
        this.getAttachProgressReporter().step("Creating device directories");
        LOG.info("Creating LLDB bin directory " + packageLLDBBinDir);
        state.executeDeviceCommandAndWriteToConsole(device, clientShell.runAs("mkdir " + packageLLDBDir), (AndroidOutputReceiver)new AndroidRunningState.MyReceiver(state));
        state.executeDeviceCommandAndWriteToConsole(device, clientShell.runAs("mkdir " + packageLLDBBinDir), (AndroidOutputReceiver)new AndroidRunningState.MyReceiver(state));
        LOG.info("Pushing LLDB files to the device");
        this.getAttachProgressReporter().step("Pushing binaries to the device");
        this.pushDebuggerFile(state, device, clientShell, lldbServer, packageLLDBBinDir);
        File startLLLDBServerScript = ModulePathManager.getAndroidLLDBBinFile(LLDB_SERVER_START_SCRIPT);
        String startScriptPath = this.pushDebuggerFile(state, device, clientShell, startLLLDBServerScript, packageLLDBBinDir);
        String platformPortFile = String.format("%s/tmp/platform.port%d", packageLLDBDir, System.currentTimeMillis());
        final String startCmd = clientShell.runAs(String.format("%s %s %s \"%s\"", startScriptPath, packageLLDBDir, platformPortFile, configuration.getTargetLoggingChannels()));
        LOG.info("Starting LLDB server: " + startCmd);
        this.getAttachProgressReporter().step("Starting LLDB server");
        state.message("Starting LLDB server: " + startCmd, ProcessOutputTypes.STDOUT);
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            @Override
            public void run() {
                try {
                    AndroidRunningState.MyReceiver receiver = new AndroidRunningState.MyReceiver(state){

                        public boolean isCancelled() {
                            return cancelled.get();
                        }
                    };
                    device.executeShellCommand(startCmd, (IShellOutputReceiver)receiver, 0L, TimeUnit.DAYS);
                    LOG.info("LLDB server has exited: " + receiver.getOutput());
                }
                catch (Exception e) {
                    LOG.error("LLDB server has failed: ", (Throwable)e);
                }
            }
        });
        this.getAttachProgressReporter().step("Waiting for LLDB server to start");
        this.readPlatformPort(device, clientShell, platformPortFile);
    }

    private void readPlatformPort(IDevice device, ClientShellHelper clientShell, String platformPortFile) {
        for (int i = 0; i < 10; ++i) {
            CollectingOutputReceiver receiver = new CollectingOutputReceiver();
            try {
                device.executeShellCommand(clientShell.runAs(String.format("cat %s 2>/dev/null", platformPortFile)), (IShellOutputReceiver)receiver);
                String output = receiver.getOutput();
                if (!output.isEmpty()) {
                    this.myPlatformPort = Integer.parseInt(output);
                    LOG.info("Platform is listening on port " + this.myPlatformPort);
                    return;
                }
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        throw new IllegalStateException("Failed to read platform port " + platformPortFile);
    }

    private static File getAndroidLLDBBinFile(Abi abi) {
        return ModulePathManager.getAndroidLLDBBinFile(new File(abi.toString(), LLDB_SERVER).getPath());
    }

    private static File findLLDBServer(AndroidRunningState state, IDevice device) {
        Abi abi;
        File lldbServerFile;
        List abis = device.getAbis();
        for (String abiStr : abis) {
            File lldbServerFile2;
            Abi abi2 = Abi.getEnum((String)abiStr);
            if (abi2 == null) {
                LOG.error("Failed to get abi by name: " + abiStr);
                continue;
            }
            if (AndroidNativeDebugProcess.getSymbolsDir(state, Collections.singletonList(abi2)).isEmpty() || (lldbServerFile2 = AndroidLLDBDebuggerContext.getServerFileByAbi(abi2)) == null) continue;
            return lldbServerFile2;
        }
        if (!abis.isEmpty() && (lldbServerFile = AndroidLLDBDebuggerContext.getServerFileByAbi(abi = Abi.getEnum((String)((String)abis.get(0))))) != null) {
            return lldbServerFile;
        }
        return null;
    }

    private static File getServerFileByAbi(Abi abi) {
        File lldbServerFile = AndroidLLDBDebuggerContext.getAndroidLLDBBinFile(abi);
        if (lldbServerFile.exists()) {
            return lldbServerFile;
        }
        Abi mappedAbi = ABI_MAPPINGS.get(abi);
        if (mappedAbi != null && (lldbServerFile = AndroidLLDBDebuggerContext.getAndroidLLDBBinFile(mappedAbi)).exists()) {
            return lldbServerFile;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SyncService.FileStat statRemoteFile(IDevice device, String remoteFile) throws TimeoutException, AdbCommandRejectedException, IOException {
        SyncService sync = null;
        try {
            sync = device.getSyncService();
            if (sync != null) {
                SyncService.FileStat fileStat = sync.statFile(remoteFile);
                return fileStat;
            }
            LOG.error("Failed to get SyncService");
        }
        finally {
            if (sync != null) {
                sync.close();
            }
        }
        return null;
    }

    private String pushDebuggerFile(AndroidRunningState state, IDevice device, ClientShellHelper clientShell, File localFile, String destDir) throws IOException, AdbCommandRejectedException, TimeoutException, SyncException, ShellCommandUnresponsiveException {
        String fileName = localFile.getName();
        String destFile = destDir + "/" + fileName;
        String tmpDestFile = "/data/local/tmp/" + fileName;
        Date localFileLmt = new Date(localFile.lastModified() / 1000L * 1000L);
        SyncService.FileStat destFileStat = AndroidLLDBDebuggerContext.statRemoteFile(device, tmpDestFile);
        if (destFileStat == null || destFileStat.getMode() == 0 || !localFileLmt.equals(destFileStat.getLastModified()) || localFile.length() != (long)destFileStat.getSize()) {
            LOG.info("Pushing to the device: " + localFile + " => " + tmpDestFile);
            device.pushFile(localFile.getAbsolutePath(), tmpDestFile);
        } else {
            LOG.info("Remote file " + tmpDestFile + " is up-to-date.");
        }
        AndroidRunningState.MyReceiver receiver = new AndroidRunningState.MyReceiver(state);
        String copyChmodCommand = "cat " + tmpDestFile + " | " + clientShell.runAs(String.format("sh -c 'cat > %s; chmod 700 %s'", destFile, destFile));
        LOG.info("Copying to app folder: " + tmpDestFile + " => " + destFile);
        LOG.info("Command: " + copyChmodCommand);
        state.executeDeviceCommandAndWriteToConsole(device, copyChmodCommand, (AndroidOutputReceiver)receiver);
        if (receiver.getErrorType() != -2) {
            throw new IOException("Command failed: " + copyChmodCommand);
        }
        return destFile;
    }
}

