/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.run.lldb;

import com.android.ddmlib.IDevice;
import com.android.tools.idea.gradle.util.Projects;
import com.android.tools.ndk.GradleWorkspace;
import com.android.tools.ndk.ModulePathManager;
import com.android.tools.ndk.NdkHelper;
import com.android.tools.ndk.run.AndroidNativeRunConfiguration;
import com.android.tools.ndk.run.lldb.AndroidLLDBDriver;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.jetbrains.cidr.execution.Installer;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.LLDBDriverConfiguration;
import com.jetbrains.cidr.execution.debugger.backend.lldb.LLDBDriver;
import java.io.File;
import java.util.Map;
import org.jetbrains.android.run.AndroidRunningState;

public class AndroidLLDBDriverConfiguration
extends LLDBDriverConfiguration {
    private final AndroidRunningState myState;
    private final IDevice myDevice;
    private final int myPlatformPort;
    private final String[] myStartupCommands;

    public AndroidLLDBDriverConfiguration(AndroidRunningState androidRunningState, IDevice device, int platformPort, String[] startupCommands) {
        this.myState = androidRunningState;
        this.myDevice = device;
        this.myPlatformPort = platformPort;
        this.myStartupCommands = startupCommands;
    }

    public AndroidRunningState getState() {
        return this.myState;
    }

    public IDevice getDevice() {
        return this.myDevice;
    }

    public int getPlatformPort() {
        return this.myPlatformPort;
    }

    public String[] getStartupCommands() {
        return this.myStartupCommands;
    }

    public DebuggerDriver createDriver(DebuggerDriver.Handler handler) {
        AndroidLLDBDriver driver = new AndroidLLDBDriver(handler, this);
        return driver;
    }

    private File getLLDBPlatformBinFile(String relativePath) {
        String selector = SystemInfo.isWindows ? "win" : (SystemInfo.isMac ? "mac" : "linux");
        return ModulePathManager.getLLDBPlatformBinFile(selector, relativePath);
    }

    protected File getLLDBBinFile(String relativePath) {
        return this.getLLDBPlatformBinFile(new File("bin", relativePath).getPath());
    }

    private File getLLDBLibDir() {
        return this.getLLDBPlatformBinFile(new File("lib").getPath());
    }

    private File getLLDBLibFile(String relativePath) {
        return new File(this.getLLDBLibDir(), relativePath);
    }

    protected File getLLDBFrameworkFile() {
        if (SystemInfo.isWindows) {
            return this.getLLDBBinFile("liblldb.dll");
        }
        if (SystemInfo.isLinux) {
            return this.getLLDBLibFile("liblldb.so.3.8");
        }
        return this.getLLDBPlatformBinFile("LLDB.framework");
    }

    protected void configureDriverCommandLine(GeneralCommandLine result) {
        File libStdCxxPrinterPath;
        AndroidNativeRunConfiguration config = (AndroidNativeRunConfiguration)this.myState.getConfiguration();
        String workingDir = config.getWorkingDir();
        if (!workingDir.isEmpty()) {
            result.withWorkDirectory(workingDir);
        }
        if (!Projects.isBuildWithGradle((Project)this.myState.getModule().getProject())) {
            return;
        }
        Map environment = result.getEnvironment();
        File galaPath = ModulePathManager.getLLDBStlPrintersFolder();
        if (galaPath.exists()) {
            environment.put("AS_GALA_PATH", galaPath.getAbsolutePath());
        }
        if ((libStdCxxPrinterPath = NdkHelper.getLibStdCxxPrintersPath(GradleWorkspace.getInstance(this.myState.getModule().getProject()).getNdkPath(), "4.9")).exists()) {
            environment.put("AS_LIBSTDCXX_PRINTER_PATH", libStdCxxPrinterPath.getAbsolutePath());
        }
    }

    public GeneralCommandLine createDriverCommandLine(DebuggerDriver driver, Installer installer, String architecture) throws ExecutionException {
        File lldbFrameworkFile = this.getLLDBFrameworkFile();
        if (!lldbFrameworkFile.exists()) {
            throw new ExecutionException(lldbFrameworkFile + " not found");
        }
        File frontendExecutable = this.getLLDBBinFile(SystemInfo.isWindows ? "LLDBFrontend.exe" : "LLDBFrontend");
        if (!frontendExecutable.exists()) {
            throw new ExecutionException(frontendExecutable.getAbsolutePath() + " not found");
        }
        GeneralCommandLine result = new GeneralCommandLine();
        result.setExePath(frontendExecutable.getAbsolutePath());
        result.addParameter(String.valueOf(((LLDBDriver)driver).getPort()));
        AndroidLLDBDriverConfiguration.setupCommonParameters((GeneralCommandLine)result);
        Map env = result.getEnvironment();
        if (SystemInfo.isLinux) {
            String libraryPath = lldbFrameworkFile.getParent();
            env.put("LD_LIBRARY_PATH", libraryPath);
            env.put("PYTHONHOME", new File(libraryPath).getParent());
        } else if (SystemInfo.isMac) {
            env.put("DYLD_FRAMEWORK_PATH", lldbFrameworkFile.getParent());
        } else {
            env.put("PYTHONPATH", this.getLLDBLibDir().getAbsolutePath());
        }
        this.configureDriverCommandLine(result);
        return result;
    }
}

