/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.instrumentation;

import com.intellij.rt.coverage.data.FileMapData;
import com.intellij.rt.coverage.data.LineMapData;
import gnu.trove.THashSet;
import gnu.trove.TIntObjectHashMap;
import java.util.Iterator;

public class JSR45Util {
    private static final String FILE_SECTION = "*F\n";
    private static final String LINE_SECTION = "*L\n";
    private static final String END_SECTION = "*E";

    public static FileMapData[] extractLineMapping(String debug, String className) {
        if (debug.startsWith("SMAP")) {
            TIntObjectHashMap linesMap = new TIntObjectHashMap();
            debug = debug.substring(4);
            int fileSectionIdx = debug.indexOf(FILE_SECTION);
            int lineInfoIdx = debug.indexOf(LINE_SECTION);
            String[] fileNames = JSR45Util.parseFileNames(debug.substring(fileSectionIdx + FILE_SECTION.length(), lineInfoIdx), className);
            String lineInfo = debug.substring(lineInfoIdx + LINE_SECTION.length(), debug.indexOf(END_SECTION));
            String[] lines = lineInfo.split("\n");
            int fileId = 0;
            for (int i = 0; i < lines.length; ++i) {
                int startOutLine;
                int startSrcLine;
                int repeat = 1;
                int outLineInc = 1;
                int idx = lines[i].indexOf(":");
                String srcLine = lines[i].substring(0, idx);
                String outLine = lines[i].substring(idx + 1);
                int srcCommaIdx = srcLine.indexOf(44);
                int sharpIdx = srcLine.indexOf("#");
                if (sharpIdx > -1) {
                    startSrcLine = Integer.parseInt(srcLine.substring(0, sharpIdx));
                    if (srcCommaIdx > -1) {
                        repeat = Integer.parseInt(srcLine.substring(srcCommaIdx + 1));
                        fileId = Integer.parseInt(srcLine.substring(sharpIdx + 1, srcCommaIdx));
                    } else {
                        fileId = Integer.parseInt(srcLine.substring(sharpIdx + 1));
                    }
                } else if (srcCommaIdx > -1) {
                    repeat = Integer.parseInt(srcLine.substring(srcCommaIdx + 1));
                    startSrcLine = Integer.parseInt(srcLine.substring(0, srcCommaIdx));
                } else {
                    startSrcLine = Integer.parseInt(srcLine);
                }
                int outCommaIdx = outLine.indexOf(44);
                if (outCommaIdx > -1) {
                    outLineInc = Integer.parseInt(outLine.substring(outCommaIdx + 1));
                    startOutLine = Integer.parseInt(outLine.substring(0, outCommaIdx));
                } else {
                    startOutLine = Integer.parseInt(outLine);
                }
                THashSet currentFile = (THashSet)linesMap.get(fileId);
                if (currentFile == null) {
                    currentFile = new THashSet();
                    linesMap.put(fileId, (Object)currentFile);
                }
                for (int r = 0; r < repeat; ++r) {
                    currentFile.add((Object)new LineMapData(startSrcLine + r, startOutLine + r * outLineInc, startOutLine + (r + 1) * outLineInc - 1));
                }
            }
            FileMapData[] result = new FileMapData[linesMap.size()];
            int[] keys = linesMap.keys();
            for (int i = 0; i < keys.length; ++i) {
                int key = keys[i];
                result[key] = new FileMapData(fileNames[key], JSR45Util.getLinesMapping((THashSet)linesMap.get(key)));
            }
            return result;
        }
        return null;
    }

    public static String[] parseFileNames(String fileSection, String className) {
        if ((fileSection = fileSection.trim()).endsWith("\n")) {
            fileSection = fileSection.substring(0, fileSection.length() - 1);
        }
        String[] fileNameIdx = fileSection.split("\n");
        String[] result = new String[fileNameIdx.length / 2];
        for (int i = 0; i < fileNameIdx.length; ++i) {
            String fileName = fileNameIdx[i];
            if (fileName.startsWith("+")) continue;
            if (i / 2 == 0) {
                result[0] = className;
                continue;
            }
            fileName = JSR45Util.processRelative(fileName);
            int lastDot = fileName.lastIndexOf(".");
            result[i / 2] = JSR45Util.getClassPackageName(className) + (fileName.substring(0, lastDot) + "_" + fileName.substring(lastDot + 1)).replace('/', '.');
        }
        return result;
    }

    public static String processRelative(String fileName) {
        int idx;
        while ((idx = fileName.indexOf("..")) > -1) {
            String rest = fileName.substring(idx + "..".length());
            String start = fileName.substring(0, idx);
            if (!start.endsWith("/")) {
                return fileName;
            }
            int endIndex = (start = start.substring(0, start.length() - 1)).lastIndexOf(47);
            if (endIndex > -1) {
                fileName = start.substring(0, endIndex) + rest;
                continue;
            }
            fileName = rest.startsWith("/") ? rest.substring(1) : rest;
        }
        return fileName;
    }

    private static String getClassPackageName(String className) {
        String generatePrefix = "";
        int fqnLastDotIdx = className.lastIndexOf(".");
        if (fqnLastDotIdx > -1) {
            generatePrefix = className.substring(0, fqnLastDotIdx + 1);
        }
        return generatePrefix;
    }

    static LineMapData[] getLinesMapping(THashSet linesMap) {
        int max = 0;
        for (LineMapData lmd : linesMap) {
            if (max >= lmd.getSourceLineNumber()) continue;
            max = lmd.getSourceLineNumber();
        }
        LineMapData[] result = new LineMapData[max + 1];
        Iterator iterator = linesMap.iterator();
        while (iterator.hasNext()) {
            LineMapData lmd;
            result[lmd.getSourceLineNumber()] = lmd = (LineMapData)iterator.next();
        }
        return result;
    }
}

