/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea;

import com.google.common.base.Objects;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.io.UnsupportedEncodingException;
import org.zmlx.hg4idea.HgFile;
import org.zmlx.hg4idea.HgRevisionNumber;
import org.zmlx.hg4idea.command.HgCatCommand;
import org.zmlx.hg4idea.util.HgUtil;

public class HgContentRevision
implements ContentRevision {
    private final Project myProject;
    private final HgFile myHgFile;
    private final HgRevisionNumber myRevisionNumber;
    private FilePath filePath;
    private String content;

    public HgContentRevision(Project project, HgFile hgFile, HgRevisionNumber revisionNumber) {
        this.myProject = project;
        this.myHgFile = hgFile;
        this.myRevisionNumber = revisionNumber;
    }

    public String getContent() throws VcsException {
        if (StringUtil.isEmptyOrSpaces((String)this.content)) {
            if (this.myRevisionNumber.isWorkingVersion()) {
                this.content = VcsUtil.getFileContent((String)this.myHgFile.getFile().getPath());
            } else {
                HgFile fileToCat = HgUtil.getFileNameInTargetRevision(this.myProject, this.myRevisionNumber, this.myHgFile);
                this.content = new HgCatCommand(this.myProject).execute(fileToCat, this.myRevisionNumber, this.getFile().getCharset());
            }
        }
        return this.content;
    }

    public byte[] getContentAsBytes() throws VcsException {
        String content = this.getContent();
        if (content == null) {
            return null;
        }
        try {
            VirtualFile vf = VcsUtil.getVirtualFile((File)this.myHgFile.getFile());
            if (vf == null) {
                return null;
            }
            return content.getBytes(vf.getCharset().name());
        }
        catch (UnsupportedEncodingException e) {
            throw new VcsException("Couldn't retrieve file content due to a UnsupportedEncodingException", (Throwable)e);
        }
    }

    public FilePath getFile() {
        if (this.filePath == null) {
            this.filePath = this.myHgFile.toFilePath();
        }
        return this.filePath;
    }

    public HgRevisionNumber getRevisionNumber() {
        return this.myRevisionNumber;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HgContentRevision revision = (HgContentRevision)o;
        if (!this.myHgFile.equals(revision.myHgFile)) {
            return false;
        }
        return this.myRevisionNumber.equals(revision.myRevisionNumber);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.myHgFile, this.myRevisionNumber});
    }
}

