/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea;

import com.google.common.base.Objects;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.RepositoryLocation;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import org.zmlx.hg4idea.HgFile;
import org.zmlx.hg4idea.HgRevisionNumber;
import org.zmlx.hg4idea.command.HgCatCommand;
import org.zmlx.hg4idea.util.HgUtil;

public class HgFileRevision
implements VcsFileRevision {
    private final Project myProject;
    private final HgFile myFile;
    private final HgRevisionNumber myRevisionNumber;
    private final String myBranchName;
    private final Date myRevisionDate;
    private final String myAuthor;
    private final String myCommitMessage;
    private final Set<String> myFilesModified;
    private final Set<String> myFilesAdded;
    private final Set<String> myFilesDeleted;
    private Map<String, String> myFilesCopied;

    public HgFileRevision(Project project, HgFile hgFile, HgRevisionNumber vcsRevisionNumber, String branchName, Date revisionDate, String author, String commitMessage, Set<String> filesModified, Set<String> filesAdded, Set<String> filesDeleted, Map<String, String> filesCopied) {
        this.myProject = project;
        this.myFile = hgFile;
        this.myRevisionNumber = vcsRevisionNumber;
        this.myBranchName = branchName;
        this.myRevisionDate = revisionDate;
        this.myAuthor = author;
        this.myCommitMessage = commitMessage;
        this.myFilesModified = filesModified;
        this.myFilesAdded = filesAdded;
        this.myFilesDeleted = filesDeleted;
        this.myFilesCopied = filesCopied;
    }

    public HgRevisionNumber getRevisionNumber() {
        return this.myRevisionNumber;
    }

    public String getBranchName() {
        return this.myBranchName;
    }

    public RepositoryLocation getChangedRepositoryPath() {
        return null;
    }

    public Date getRevisionDate() {
        return this.myRevisionDate;
    }

    public String getAuthor() {
        return this.myAuthor;
    }

    public String getCommitMessage() {
        return this.myCommitMessage;
    }

    public Set<String> getModifiedFiles() {
        return this.myFilesModified;
    }

    public Set<String> getAddedFiles() {
        return this.myFilesAdded;
    }

    public Set<String> getDeletedFiles() {
        return this.myFilesDeleted;
    }

    public Map<String, String> getCopiedFiles() {
        return this.myFilesCopied;
    }

    public byte[] loadContent() throws IOException, VcsException {
        try {
            Charset charset = this.myFile.toFilePath().getCharset();
            HgFile fileToCat = HgUtil.getFileNameInTargetRevision(this.myProject, this.myRevisionNumber, this.myFile);
            String result = new HgCatCommand(this.myProject).execute(fileToCat, this.myRevisionNumber, charset);
            if (result == null) {
                return new byte[0];
            }
            return result.getBytes(charset.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new VcsException((Throwable)e);
        }
    }

    public byte[] getContent() throws IOException, VcsException {
        return this.loadContent();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HgFileRevision revision = (HgFileRevision)o;
        if (!this.myFile.equals(revision.myFile)) {
            return false;
        }
        return this.myRevisionNumber.equals(revision.myRevisionNumber);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.myFile, this.myRevisionNumber});
    }
}

