/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea;

import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsListener;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.util.messages.MessageBus;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.zmlx.hg4idea.HgUpdater;
import org.zmlx.hg4idea.HgVcs;

public class HgRepositoryWatcher
extends AbstractProjectComponent
implements BulkFileListener,
VcsListener {
    private final Collection<LocalFileSystem.WatchRequest> myWatchRequests = new HashSet<LocalFileSystem.WatchRequest>();
    private final Collection<VirtualFile> myRoots = new HashSet<VirtualFile>();
    private VcsDirtyScopeManager myDirtyScopeManager;
    private ProjectLevelVcsManager myVcsManager;
    private AbstractVcs myVcs;

    protected HgRepositoryWatcher(Project project) {
        super(project);
    }

    public void initComponent() {
        MessageBus messageBus = this.myProject.getMessageBus();
        messageBus.connect().subscribe(VirtualFileManager.VFS_CHANGES, (Object)this);
        messageBus.connect().subscribe(ProjectLevelVcsManager.VCS_CONFIGURATION_CHANGED, (Object)this);
        this.myDirtyScopeManager = VcsDirtyScopeManager.getInstance((Project)this.myProject);
        this.myVcsManager = ProjectLevelVcsManager.getInstance((Project)this.myProject);
        this.myVcs = HgVcs.getInstance(this.myProject);
    }

    public void disposeComponent() {
        LocalFileSystem.getInstance().removeWatchedRoots(this.myWatchRequests);
        this.myWatchRequests.clear();
        this.myRoots.clear();
    }

    public void before(List<? extends VFileEvent> events) {
    }

    public void after(List<? extends VFileEvent> events) {
        for (VFileEvent vFileEvent : events) {
            VirtualFile file = vFileEvent.getFile();
            VirtualFile root = this.getRootForIndexFile(file);
            if (root != null) {
                this.myDirtyScopeManager.dirDirtyRecursively(root);
            }
            if ((root = this.getRootForChangeBranch(file)) == null) continue;
            ((HgUpdater)this.myProject.getMessageBus().syncPublisher(HgVcs.REMOTE_TOPIC)).update(this.myProject, root);
        }
    }

    private VirtualFile getRootForIndexFile(VirtualFile file) {
        if (file == null) {
            return null;
        }
        for (VirtualFile root : this.myRoots) {
            if (!HgRepositoryWatcher.isDirstateFile(file, root) && !HgRepositoryWatcher.isUndoDirstateFile(file, root)) continue;
            return root;
        }
        return null;
    }

    private static boolean isDirstateFile(VirtualFile file, VirtualFile root) {
        return FileUtil.pathsEqual((String)(root.getPath() + "/.hg/dirstate"), (String)file.getPath());
    }

    private static boolean isUndoDirstateFile(VirtualFile file, VirtualFile root) {
        return FileUtil.pathsEqual((String)(root.getPath() + "/.hg/undo.dirstate"), (String)file.getPath());
    }

    private VirtualFile getRootForChangeBranch(VirtualFile file) {
        if (file == null) {
            return null;
        }
        for (VirtualFile root : this.myRoots) {
            if (!HgRepositoryWatcher.isChangeBranchFile(file, root) && !HgRepositoryWatcher.isUndoChangeBranchFile(file, root)) continue;
            return root;
        }
        return null;
    }

    private static boolean isChangeBranchFile(VirtualFile file, VirtualFile root) {
        return FileUtil.pathsEqual((String)(root.getPath() + "/.hg/branch"), (String)file.getPath());
    }

    private static boolean isUndoChangeBranchFile(VirtualFile file, VirtualFile root) {
        return FileUtil.pathsEqual((String)(root.getPath() + "/.hg/undo.branch"), (String)file.getPath());
    }

    private void registerRoot(VirtualFile root) {
        this.myWatchRequests.add(LocalFileSystem.getInstance().addRootToWatch(root.getPath(), true));
        this.myRoots.add(root);
    }

    public void directoryMappingChanged() {
        for (VirtualFile root : this.myVcsManager.getRootsUnderVcs(this.myVcs)) {
            this.registerRoot(root);
        }
    }
}

