/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea;

import com.intellij.dvcs.branch.DvcsTaskHandler;
import com.intellij.dvcs.repo.AbstractRepositoryManager;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.update.UpdatedFiles;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.zmlx.hg4idea.branch.HgBranchUtil;
import org.zmlx.hg4idea.command.HgBookmarkCommand;
import org.zmlx.hg4idea.command.HgCommitCommand;
import org.zmlx.hg4idea.command.HgMergeCommand;
import org.zmlx.hg4idea.command.HgUpdateCommand;
import org.zmlx.hg4idea.execution.HgCommandException;
import org.zmlx.hg4idea.repo.HgRepository;
import org.zmlx.hg4idea.repo.HgRepositoryManager;
import org.zmlx.hg4idea.util.HgErrorUtil;
import org.zmlx.hg4idea.util.HgUtil;

public class HgTaskHandler
extends DvcsTaskHandler<HgRepository> {
    public HgTaskHandler(HgRepositoryManager repositoryManager, Project project) {
        super((AbstractRepositoryManager)repositoryManager, project, "bookmark");
    }

    protected void checkout(String taskName, List<HgRepository> repos, Runnable callInAwtLater) {
        HgUpdateCommand.updateTo(!HgBranchUtil.getCommonBookmarks(repos).contains(taskName) ? "head() and not bookmark() and branch(" + taskName + ")" : taskName, repos, callInAwtLater);
    }

    protected void checkoutAsNewBranch(String name, List<HgRepository> repositories) {
        HgBookmarkCommand.createBookmark(repositories, name, true);
    }

    protected String getActiveBranch(HgRepository repository) {
        String bookmark = repository.getCurrentBookmark();
        return bookmark == null ? repository.getCurrentBranch() : bookmark;
    }

    protected Iterable<String> getAllBranches(HgRepository repository) {
        return ContainerUtil.concat((Iterable[])new Iterable[]{HgUtil.getNamesWithoutHashes(repository.getBookmarks()), repository.getOpenedBranches()});
    }

    protected void mergeAndClose(final String branch, List<HgRepository> repositories) {
        String bookmarkRevisionArg = "bookmark(\"" + branch + "\")";
        FileDocumentManager.getInstance().saveAllDocuments();
        UpdatedFiles updatedFiles = UpdatedFiles.create();
        for (final HgRepository repository : repositories) {
            HgMergeCommand.mergeWith(repository, bookmarkRevisionArg, updatedFiles, new Runnable(){

                @Override
                public void run() {
                    Project project = repository.getProject();
                    VirtualFile repositoryRoot = repository.getRoot();
                    try {
                        new HgCommitCommand(project, repository, "Automated merge with " + branch).execute();
                        new HgBookmarkCommand(project, repositoryRoot, branch).deleteBookmark();
                    }
                    catch (HgCommandException e) {
                        HgErrorUtil.handleException(project, e);
                    }
                    catch (VcsException e) {
                        VcsNotifier.getInstance((Project)project).notifyError("Exception during merge commit with " + branch, e.getMessage());
                    }
                }
            });
        }
    }

    protected boolean hasBranch(HgRepository repository, String name) {
        return HgUtil.getNamesWithoutHashes(repository.getBookmarks()).contains(name) || repository.getOpenedBranches().contains(name);
    }
}

