/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.action;

import com.intellij.dvcs.repo.Repository;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import org.zmlx.hg4idea.action.HgCommandResultNotifier;
import org.zmlx.hg4idea.action.HgProcessStateAction;
import org.zmlx.hg4idea.command.HgRebaseCommand;
import org.zmlx.hg4idea.execution.HgCommandResult;
import org.zmlx.hg4idea.repo.HgRepository;
import org.zmlx.hg4idea.util.HgErrorUtil;

public class HgAbortRebaseAction
extends HgProcessStateAction {
    public HgAbortRebaseAction() {
        super(Repository.State.REBASING);
    }

    @Override
    protected void execute(final Project project, Collection<HgRepository> repositories, final HgRepository selectedRepo) {
        new Task.Backgroundable(project, "Abort Rebasing..."){

            public void run(ProgressIndicator indicator) {
                if (selectedRepo != null) {
                    HgRebaseCommand rebaseCommand = new HgRebaseCommand(project, selectedRepo);
                    HgCommandResult result = rebaseCommand.abortRebase();
                    if (HgErrorUtil.isAbort(result)) {
                        new HgCommandResultNotifier(project).notifyError(result, "Hg Error", "Couldn't abort rebasing");
                    }
                    HgErrorUtil.markDirtyAndHandleErrors(project, selectedRepo.getRoot());
                }
            }
        }.queue();
    }
}

