/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.action;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.sun.istack.internal.NotNull;
import java.util.Collection;
import java.util.List;
import org.zmlx.hg4idea.repo.HgRepository;
import org.zmlx.hg4idea.repo.HgRepositoryManager;
import org.zmlx.hg4idea.util.HgUtil;

public class HgActionUtil {
    @NotNull
    public static List<HgRepository> collectRepositoriesFromFiles(final @NotNull HgRepositoryManager repositoryManager, @NotNull Collection<VirtualFile> files) {
        return ContainerUtil.mapNotNull(files, (Function)new Function<VirtualFile, HgRepository>(){

            public HgRepository fun(VirtualFile file) {
                return (HgRepository)repositoryManager.getRepositoryForFile(file);
            }
        });
    }

    public static HgRepository getSelectedRepositoryFromEvent(AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            return null;
        }
        VirtualFile file = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        HgRepositoryManager repositoryManager = HgUtil.getRepositoryManager(project);
        return file != null ? (HgRepository)repositoryManager.getRepositoryForFile(file) : HgUtil.getCurrentRepository(project);
    }
}

