/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.action;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import org.zmlx.hg4idea.HgVcsMessages;
import org.zmlx.hg4idea.action.HgAbstractGlobalSingleRepoAction;
import org.zmlx.hg4idea.provider.update.HgConflictResolver;
import org.zmlx.hg4idea.repo.HgRepository;
import org.zmlx.hg4idea.ui.HgRunConflictResolverDialog;
import org.zmlx.hg4idea.util.HgErrorUtil;

public class HgRunConflictResolverAction
extends HgAbstractGlobalSingleRepoAction {
    @Override
    public void execute(final Project project, Collection<HgRepository> repositories, HgRepository selectedRepo) {
        HgRepository repository;
        HgRepository hgRepository = repository = repositories.size() > 1 ? HgRunConflictResolverAction.letUserSelectRepository(project, repositories, selectedRepo) : (HgRepository)ContainerUtil.getFirstItem(repositories);
        if (repository != null) {
            new Task.Backgroundable(project, HgVcsMessages.message("action.hg4idea.run.conflict.resolver.description", new Object[0])){

                public void run(ProgressIndicator indicator) {
                    new HgConflictResolver(project).resolve(repository.getRoot());
                    HgErrorUtil.markDirtyAndHandleErrors(project, repository.getRoot());
                }
            }.queue();
        }
    }

    private static HgRepository letUserSelectRepository(Project project, Collection<HgRepository> repositories, HgRepository selectedRepo) {
        HgRunConflictResolverDialog dialog = new HgRunConflictResolverDialog(project, repositories, selectedRepo);
        return dialog.showAndGet() ? dialog.getRepository() : null;
    }
}

