/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.command;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.zmlx.hg4idea.action.HgCommandResultNotifier;
import org.zmlx.hg4idea.execution.HgCommandException;
import org.zmlx.hg4idea.execution.HgCommandExecutor;
import org.zmlx.hg4idea.execution.HgCommandResult;
import org.zmlx.hg4idea.execution.HgCommandResultHandler;
import org.zmlx.hg4idea.repo.HgRepository;
import org.zmlx.hg4idea.util.HgErrorUtil;
import org.zmlx.hg4idea.util.HgUtil;

public class HgBookmarkCommand {
    private final Project myProject;
    private final VirtualFile myRepo;
    private final String myBookmarkName;
    private final HgCommandResultHandler myBookmarkResultHandler;

    public HgBookmarkCommand(Project project, VirtualFile repo, String bookmarkName) {
        this.myProject = project;
        this.myRepo = repo;
        this.myBookmarkName = bookmarkName;
        this.myBookmarkResultHandler = new HgCommandResultHandler(){

            @Override
            public void process(HgCommandResult result) {
                if (HgBookmarkCommand.this.myProject.isDisposed()) {
                    return;
                }
                HgUtil.getRepositoryManager(HgBookmarkCommand.this.myProject).updateRepository(HgBookmarkCommand.this.myRepo);
                if (HgErrorUtil.hasErrorsInCommandExecution(result)) {
                    new HgCommandResultNotifier(HgBookmarkCommand.this.myProject).notifyError(result, "Hg Error", "Hg bookmark command failed for " + HgBookmarkCommand.this.myBookmarkName);
                }
            }
        };
    }

    public void createBookmark(boolean isActive) throws HgCommandException {
        if (isActive) {
            this.executeBookmarkCommand(new String[0]);
        } else {
            this.executeBookmarkCommand("--inactive");
        }
    }

    public static void createBookmark(List<HgRepository> repositories, String name, boolean isActive) {
        for (HgRepository repository : repositories) {
            Project project = repository.getProject();
            try {
                new HgBookmarkCommand(project, repository.getRoot(), name).createBookmark(isActive);
            }
            catch (HgCommandException exception) {
                HgErrorUtil.handleException(project, exception);
            }
        }
    }

    public void deleteBookmark() throws HgCommandException {
        this.executeBookmarkCommand("-d");
    }

    private void executeBookmarkCommand(String ... args) throws HgCommandException {
        if (StringUtil.isEmptyOrSpaces((String)this.myBookmarkName)) {
            throw new HgCommandException("bookmark name is empty");
        }
        ArrayList arguments = ContainerUtil.newArrayList((Object[])args);
        arguments.add(this.myBookmarkName);
        new HgCommandExecutor(this.myProject).execute(this.myRepo, "bookmark", arguments, this.myBookmarkResultHandler);
    }
}

