/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.command;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.zmlx.hg4idea.execution.HgCommandExecutor;
import org.zmlx.hg4idea.execution.HgCommandResult;

public class HgBranchesCommand {
    private static final Pattern BRANCH_LINE = Pattern.compile("(.+)\\s([0-9]+):([0-9a-f]+).*");
    private static final int NAME_INDEX = 1;
    private final Project project;
    private final VirtualFile repo;

    public HgBranchesCommand(Project project, VirtualFile repo) {
        this.project = project;
        this.repo = repo;
    }

    public HgCommandResult collectBranches() {
        return new HgCommandExecutor(this.project).executeInCurrentThread(this.repo, "branches", null);
    }

    public static Set<String> collectNames(HgCommandResult result) {
        TreeSet<String> branches = new TreeSet<String>();
        for (String line : result.getOutputLines()) {
            Matcher matcher = BRANCH_LINE.matcher(line);
            if (!matcher.matches()) continue;
            branches.add(matcher.group(1).trim());
        }
        return branches;
    }
}

