/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.command;

import com.intellij.dvcs.repo.Repository;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBus;
import com.intellij.vcsUtil.VcsFileUtil;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.zmlx.hg4idea.HgErrorHandler;
import org.zmlx.hg4idea.HgFile;
import org.zmlx.hg4idea.HgUpdater;
import org.zmlx.hg4idea.HgVcs;
import org.zmlx.hg4idea.HgVcsMessages;
import org.zmlx.hg4idea.execution.HgCommandException;
import org.zmlx.hg4idea.execution.HgCommandExecutor;
import org.zmlx.hg4idea.repo.HgRepository;
import org.zmlx.hg4idea.util.HgEncodingUtil;

public class HgCommitCommand {
    private static final String TEMP_FILE_NAME = ".hg4idea-commit.tmp";
    private final Project myProject;
    private final HgRepository myRepository;
    private final String myMessage;
    private final Charset myCharset;
    private final boolean myAmend;
    private final boolean myCloseBranch;
    private Set<HgFile> myFiles = Collections.emptySet();
    private List<String> mySubrepos = Collections.emptyList();

    public HgCommitCommand(Project project, HgRepository repository, String message, boolean amend, boolean closeBranch) {
        this.myProject = project;
        this.myRepository = repository;
        this.myMessage = message;
        this.myCharset = HgEncodingUtil.getDefaultCharset(this.myProject);
        this.myAmend = amend;
        this.myCloseBranch = closeBranch;
    }

    public HgCommitCommand(Project project, HgRepository repo, String message, boolean amend) {
        this(project, repo, message, amend, false);
    }

    public HgCommitCommand(Project project, HgRepository repo, String message) {
        this(project, repo, message, false);
    }

    public void setFiles(Set<HgFile> files) {
        this.myFiles = files;
    }

    public void setSubrepos(List<String> subrepos) {
        this.mySubrepos = subrepos;
    }

    public void execute() throws HgCommandException, VcsException {
        if (StringUtil.isEmptyOrSpaces((String)this.myMessage)) {
            throw new HgCommandException(HgVcsMessages.message("hg4idea.commit.error.messageEmpty", new Object[0]));
        }
        if (this.myFiles.isEmpty()) {
            this.commitChunkFiles(Collections.<String>emptyList(), this.myAmend, this.myCloseBranch);
        } else {
            List relativePaths = ContainerUtil.map2List(this.myFiles, (Function)new Function<HgFile, String>(){

                public String fun(HgFile file) {
                    return file.getRelativePath();
                }
            });
            List chunkedCommits = VcsFileUtil.chunkRelativePaths((List)relativePaths);
            int size = chunkedCommits.size();
            this.commitChunkFiles((List)chunkedCommits.get(0), this.myAmend, !this.mySubrepos.isEmpty(), this.myCloseBranch && size == 1);
            HgVcs vcs = HgVcs.getInstance(this.myProject);
            boolean amendCommit = vcs != null && vcs.getVersion().isAmendSupported();
            for (int i = 1; i < size; ++i) {
                List chunk = (List)chunkedCommits.get(i);
                this.commitChunkFiles(chunk, amendCommit, false, this.myCloseBranch && i == size - 1);
            }
        }
        this.myRepository.update();
        MessageBus messageBus = this.myProject.getMessageBus();
        ((HgUpdater)messageBus.syncPublisher(HgVcs.REMOTE_TOPIC)).update(this.myProject, null);
    }

    private void commitChunkFiles(List<String> chunk, boolean amendCommit, boolean closeBranch) throws VcsException {
        this.commitChunkFiles(chunk, amendCommit, false, closeBranch);
    }

    private void commitChunkFiles(List<String> chunk, boolean amendCommit, boolean withSubrepos, boolean closeBranch) throws VcsException {
        LinkedList<String> parameters = new LinkedList<String>();
        parameters.add("--logfile");
        parameters.add(this.saveCommitMessage().getAbsolutePath());
        if (withSubrepos) {
            parameters.add("-S");
            parameters.addAll(this.mySubrepos);
        } else if (amendCommit) {
            parameters.add("--amend");
        }
        if (closeBranch) {
            if (chunk.isEmpty() && this.myRepository.getState() != Repository.State.MERGING) {
                parameters.add("-X");
                parameters.add("\"**\"");
            }
            parameters.add("--close-branch");
        }
        parameters.addAll(chunk);
        HgCommandExecutor executor = new HgCommandExecutor(this.myProject);
        executor.setCharset(this.myCharset);
        HgErrorHandler.ensureSuccess(executor.executeInCurrentThread(this.myRepository.getRoot(), "commit", parameters));
    }

    private File saveCommitMessage() throws VcsException {
        File systemDir = new File(PathManager.getSystemPath());
        File tempFile = new File(systemDir, TEMP_FILE_NAME);
        try {
            FileUtil.writeToFile((File)tempFile, (byte[])this.myMessage.getBytes(this.myCharset));
        }
        catch (IOException e) {
            throw new VcsException("Couldn't prepare commit message", (Throwable)e);
        }
        return tempFile;
    }
}

