/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.command;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.zmlx.hg4idea.execution.HgCommandExecutor;
import org.zmlx.hg4idea.execution.HgCommandResult;
import org.zmlx.hg4idea.repo.HgRepository;

public class HgGraftCommand {
    private final Project myProject;
    private final HgRepository myRepository;

    public HgGraftCommand(Project project, HgRepository repo) {
        this.myProject = project;
        this.myRepository = repo;
    }

    public HgCommandResult startGrafting(List<String> hashes) {
        return this.graft(hashes);
    }

    public HgCommandResult continueGrafting() {
        return this.graft(Collections.singletonList("--continue"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HgCommandResult graft(List<String> params) {
        ArrayList<String> args = new ArrayList<String>();
        args.add("--log");
        args.addAll(params);
        AccessToken token = DvcsUtil.workingTreeChangeStarted((Project)this.myProject);
        try {
            HgCommandResult result = new HgCommandExecutor(this.myProject).executeInCurrentThread(this.myRepository.getRoot(), "graft", args);
            this.myRepository.update();
            HgCommandResult hgCommandResult = result;
            return hgCommandResult;
        }
        finally {
            DvcsUtil.workingTreeChangeFinished((Project)this.myProject, (AccessToken)token);
        }
    }
}

