/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.command;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.project.Project;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import org.zmlx.hg4idea.execution.HgCommandExecutor;
import org.zmlx.hg4idea.execution.HgCommandResult;
import org.zmlx.hg4idea.repo.HgRepository;

public class HgRebaseCommand {
    private final Project project;
    private final HgRepository repo;

    public HgRebaseCommand(Project project, HgRepository repo) {
        this.project = project;
        this.repo = repo;
    }

    public HgCommandResult startRebase() {
        return this.performRebase(ArrayUtil.EMPTY_STRING_ARRAY);
    }

    public HgCommandResult continueRebase() {
        return this.performRebase("--continue");
    }

    public HgCommandResult abortRebase() {
        return this.performRebase("--abort");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HgCommandResult performRebase(String ... args) {
        AccessToken token = DvcsUtil.workingTreeChangeStarted((Project)this.project);
        try {
            HgCommandResult result = new HgCommandExecutor(this.project).executeInCurrentThread(this.repo.getRoot(), "rebase", ContainerUtil.list((Object[])args));
            this.repo.update();
            HgCommandResult hgCommandResult = result;
            return hgCommandResult;
        }
        finally {
            DvcsUtil.workingTreeChangeFinished((Project)this.project, (AccessToken)token);
        }
    }
}

