/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.command;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import java.util.LinkedList;
import org.zmlx.hg4idea.HgRevisionNumber;
import org.zmlx.hg4idea.execution.HgCommandExecutor;
import org.zmlx.hg4idea.execution.HgCommandResult;

public class HgRevertCommand {
    private final Project project;

    public HgRevertCommand(Project project) {
        this.project = project;
    }

    public HgCommandResult execute(VirtualFile repo, Collection<String> files, HgRevisionNumber vcsRevisionNumber, boolean backupFile) {
        LinkedList<String> options = new LinkedList<String>();
        if (vcsRevisionNumber != null && !HgRevisionNumber.NULL_REVISION_NUMBER.equals(vcsRevisionNumber)) {
            options.add("--rev");
            if (!StringUtil.isEmptyOrSpaces((String)vcsRevisionNumber.getChangeset())) {
                options.add(vcsRevisionNumber.getChangeset());
            } else {
                options.add(vcsRevisionNumber.getRevision());
            }
        }
        if (!backupFile) {
            options.add("--no-backup");
        }
        options.addAll(files);
        return new HgCommandExecutor(this.project).executeInCurrentThread(repo, "revert", options);
    }
}

