/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.execution;

import com.intellij.ide.passwordSafe.PasswordSafe;
import com.intellij.ide.passwordSafe.PasswordSafeException;
import com.intellij.ide.passwordSafe.config.PasswordSafeSettings;
import com.intellij.ide.passwordSafe.impl.PasswordSafeImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.vcsUtil.AuthDialog;
import org.zmlx.hg4idea.HgGlobalSettings;
import org.zmlx.hg4idea.HgVcs;
import org.zmlx.hg4idea.HgVcsMessages;

class HgCommandAuthenticator {
    private static final Logger LOG = Logger.getInstance((String)HgCommandAuthenticator.class.getName());
    private GetPasswordRunnable myGetPassword;
    private final Project myProject;
    private boolean myForceAuthorization;
    private boolean mySilentMode;

    public HgCommandAuthenticator(Project project, boolean forceAuthorization, boolean silent) {
        this.myProject = project;
        this.myForceAuthorization = forceAuthorization;
        this.mySilentMode = silent;
    }

    public void saveCredentials() {
        if (this.myGetPassword == null) {
            return;
        }
        PasswordSafeImpl passwordSafe = (PasswordSafeImpl)PasswordSafe.getInstance();
        String url = VirtualFileManager.extractPath((String)this.myGetPassword.getURL());
        String key = HgCommandAuthenticator.keyForUrlAndLogin(url, this.myGetPassword.getUserName());
        try {
            if (this.myGetPassword.isRememberPassword()) {
                PasswordSafe.getInstance().storePassword(this.myProject, HgCommandAuthenticator.class, key, this.myGetPassword.getPassword());
            } else if (passwordSafe.getSettings().getProviderType() != PasswordSafeSettings.ProviderType.DO_NOT_STORE) {
                passwordSafe.getMemoryProvider().storePassword(this.myProject, HgCommandAuthenticator.class, key, this.myGetPassword.getPassword());
            }
            HgVcs vcs = HgVcs.getInstance(this.myProject);
            if (vcs != null) {
                vcs.getGlobalSettings().addRememberedUrl(url, this.myGetPassword.getUserName());
            }
        }
        catch (PasswordSafeException e) {
            LOG.info("Couldn't store the password for key [" + key + "]", (Throwable)e);
        }
    }

    public boolean promptForAuthentication(Project project, String proposedLogin, String uri, String path, ModalityState state) {
        GetPasswordRunnable runnable = new GetPasswordRunnable(project, proposedLogin, uri, path, this.myForceAuthorization, this.mySilentMode);
        ApplicationManager.getApplication().invokeAndWait((Runnable)runnable, state == null ? ModalityState.defaultModalityState() : state);
        this.myGetPassword = runnable;
        return runnable.isOk();
    }

    public String getUserName() {
        return this.myGetPassword.getUserName();
    }

    public String getPassword() {
        return this.myGetPassword.getPassword();
    }

    private static String keyForUrlAndLogin(String stringUrl, String login) {
        return login + ":" + stringUrl;
    }

    private static class GetPasswordRunnable
    implements Runnable {
        private static final Logger LOG = Logger.getInstance((String)GetPasswordRunnable.class.getName());
        private String myUserName;
        private String myPassword;
        private Project myProject;
        private final String myProposedLogin;
        private boolean ok = false;
        private String myURL;
        private boolean myRememberPassword;
        private boolean myForceAuthorization;
        private final boolean mySilent;

        public GetPasswordRunnable(Project project, String proposedLogin, String uri, String path, boolean forceAuthorization, boolean silent) {
            this.myProject = project;
            this.myProposedLogin = proposedLogin;
            this.myURL = uri + path;
            this.myForceAuthorization = forceAuthorization;
            this.mySilent = silent;
        }

        @Override
        public void run() {
            String login;
            HgVcs vcs = HgVcs.getInstance(this.myProject);
            if (vcs == null) {
                return;
            }
            HgGlobalSettings hgGlobalSettings = vcs.getGlobalSettings();
            String rememberedLoginsForUrl = null;
            if (!StringUtil.isEmptyOrSpaces((String)this.myURL)) {
                rememberedLoginsForUrl = hgGlobalSettings.getRememberedUserName(VirtualFileManager.extractPath((String)this.myURL));
            }
            if (StringUtil.isEmptyOrSpaces((String)(login = this.myProposedLogin))) {
                login = rememberedLoginsForUrl;
            }
            String password = null;
            if (!StringUtil.isEmptyOrSpaces((String)login) && this.myURL != null) {
                String key = HgCommandAuthenticator.keyForUrlAndLogin(this.myURL, login);
                try {
                    PasswordSafeImpl passwordSafe = (PasswordSafeImpl)PasswordSafe.getInstance();
                    password = this.mySilent ? passwordSafe.getMemoryProvider().getPassword(this.myProject, HgCommandAuthenticator.class, key) : passwordSafe.getPassword(this.myProject, HgCommandAuthenticator.class, key);
                }
                catch (PasswordSafeException e) {
                    LOG.info("Couldn't get password for key [" + key + "]", (Throwable)e);
                }
            }
            if (!(this.myForceAuthorization || StringUtil.isEmptyOrSpaces(password) || StringUtil.isEmptyOrSpaces((String)login))) {
                this.myUserName = login;
                this.myPassword = password;
                this.ok = true;
                return;
            }
            if (this.mySilent) {
                this.ok = false;
                return;
            }
            AuthDialog dialog = new AuthDialog(this.myProject, HgVcsMessages.message("hg4idea.dialog.login.password.required", new Object[0]), HgVcsMessages.message("hg4idea.dialog.login.description", this.myURL), login, password, true);
            if (dialog.showAndGet()) {
                this.myUserName = dialog.getUsername();
                this.myPassword = dialog.getPassword();
                this.myRememberPassword = dialog.isRememberPassword();
                this.ok = true;
            }
        }

        public String getUserName() {
            return this.myUserName;
        }

        public String getPassword() {
            return this.myPassword;
        }

        public boolean isOk() {
            return this.ok;
        }

        public String getURL() {
            return this.myURL;
        }

        public boolean isRememberPassword() {
            return this.myRememberPassword;
        }
    }
}

