/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.provider;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.history.BaseDiffFromHistoryHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import java.util.List;
import org.zmlx.hg4idea.HgFileRevision;
import org.zmlx.hg4idea.util.HgUtil;

public class HgDiffFromHistoryHandler
extends BaseDiffFromHistoryHandler<HgFileRevision> {
    private static final Logger LOG = Logger.getInstance(HgDiffFromHistoryHandler.class);

    public HgDiffFromHistoryHandler(Project project) {
        super(project);
    }

    protected List<Change> getChangesBetweenRevisions(FilePath path, HgFileRevision rev1, HgFileRevision rev2) {
        return this.executeDiff(path, rev1, rev2);
    }

    protected List<Change> getAffectedChanges(FilePath path, HgFileRevision rev) throws VcsException {
        return this.executeDiff(path, null, rev);
    }

    protected String getPresentableName(HgFileRevision revision) {
        return revision.getRevisionNumber().getChangeset();
    }

    private List<Change> executeDiff(FilePath path, HgFileRevision rev1, HgFileRevision rev2) {
        VirtualFile root = VcsUtil.getVcsRootFor((Project)this.myProject, (FilePath)path);
        LOG.assertTrue(root != null, (Object)("Repository is null for " + path));
        return HgUtil.getDiff(this.myProject, root, path, rev1, rev2);
    }
}

