/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.provider.update;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.update.UpdatedFiles;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.zmlx.hg4idea.HgFile;
import org.zmlx.hg4idea.HgVcs;
import org.zmlx.hg4idea.command.HgResolveCommand;
import org.zmlx.hg4idea.command.HgResolveStatusEnum;

public final class HgConflictResolver {
    private final Project myProject;
    private final UpdatedFiles updatedFiles;

    public HgConflictResolver(Project project) {
        this(project, null);
    }

    public HgConflictResolver(Project project, UpdatedFiles updatedFiles) {
        this.myProject = project;
        this.updatedFiles = updatedFiles;
    }

    public void resolve(VirtualFile repo) {
        Map<HgFile, HgResolveStatusEnum> resolves = new HgResolveCommand(this.myProject).getListSynchronously(repo);
        final ArrayList<VirtualFile> conflicts = new ArrayList<VirtualFile>();
        for (Map.Entry<HgFile, HgResolveStatusEnum> entry : resolves.entrySet()) {
            File file = entry.getKey().getFile();
            String fileGroupId = null;
            switch (entry.getValue()) {
                case UNRESOLVED: {
                    conflicts.add(VcsUtil.getVirtualFile((File)file));
                    fileGroupId = "MERGED_WITH_CONFLICTS";
                    break;
                }
                case RESOLVED: {
                    fileGroupId = "MERGED";
                    break;
                }
            }
            if (this.updatedFiles == null || fileGroupId == null) continue;
            this.updatedFiles.getGroupById("UPDATED").remove(file.getAbsolutePath());
            this.updatedFiles.getGroupById(fileGroupId).add(file.getPath(), "hg4idea", null);
        }
        if (conflicts.isEmpty()) {
            return;
        }
        final HgVcs vcs = HgVcs.getInstance(this.myProject);
        if (vcs == null) {
            return;
        }
        ApplicationManager.getApplication().invokeAndWait(new Runnable(){

            @Override
            public void run() {
                AbstractVcsHelper.getInstance((Project)HgConflictResolver.this.myProject).showMergeDialog(conflicts, vcs.getMergeProvider());
            }
        }, ModalityState.defaultModalityState());
    }

    public static List<VirtualFile> findConflicts(Project project, VirtualFile repo) {
        Map<HgFile, HgResolveStatusEnum> resolves = new HgResolveCommand(project).getListSynchronously(repo);
        ArrayList<VirtualFile> conflicts = new ArrayList<VirtualFile>();
        for (Map.Entry<HgFile, HgResolveStatusEnum> entry : resolves.entrySet()) {
            File file = entry.getKey().getFile();
            switch (entry.getValue()) {
                case UNRESOLVED: {
                    conflicts.add(VcsUtil.getVirtualFile((File)file));
                    break;
                }
            }
        }
        return conflicts;
    }
}

