/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.repo;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.zmlx.hg4idea.command.HgShowConfigCommand;

public class HgConfig {
    private final Map<String, Map<String, String>> myConfigMap;

    public static HgConfig getInstance(Project project, VirtualFile root) {
        return new HgConfig(project, root);
    }

    private HgConfig(Project project, VirtualFile repo) {
        this.myConfigMap = new HgShowConfigCommand(project).execute(repo);
    }

    public String getDefaultPath() {
        return this.getNamedConfig("paths", "default");
    }

    public String getDefaultPushPath() {
        String path = this.getNamedConfig("paths", "default-push");
        return path != null ? path : this.getNamedConfig("paths", "default");
    }

    public String getNamedConfig(String sectionName, String configName) {
        if (StringUtil.isEmptyOrSpaces((String)sectionName) || StringUtil.isEmptyOrSpaces((String)configName)) {
            return null;
        }
        Map<String, String> sectionValues = this.myConfigMap.get(sectionName);
        return sectionValues != null ? sectionValues.get(configName) : null;
    }

    public Collection<String> getPaths() {
        Map<String, String> pathOptions = this.myConfigMap.get("paths");
        return pathOptions != null ? pathOptions.values() : Collections.emptyList();
    }
}

