/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.repo;

import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.repo.RepositoryImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.Hash;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.zmlx.hg4idea.HgNameWithHashInfo;
import org.zmlx.hg4idea.HgUpdater;
import org.zmlx.hg4idea.HgVcs;
import org.zmlx.hg4idea.command.HgBranchesCommand;
import org.zmlx.hg4idea.execution.HgCommandResult;
import org.zmlx.hg4idea.repo.HgConfig;
import org.zmlx.hg4idea.repo.HgRepoInfo;
import org.zmlx.hg4idea.repo.HgRepository;
import org.zmlx.hg4idea.repo.HgRepositoryReader;
import org.zmlx.hg4idea.repo.HgRepositoryUpdater;

public class HgRepositoryImpl
extends RepositoryImpl
implements HgRepository {
    private static final Logger LOG = Logger.getInstance(HgRepositoryImpl.class);
    private final HgRepositoryReader myReader;
    private final VirtualFile myHgDir;
    private volatile HgRepoInfo myInfo;
    private Set<String> myOpenedBranches = Collections.emptySet();
    private volatile HgConfig myConfig;
    private boolean myIsFresh = true;

    private HgRepositoryImpl(VirtualFile rootDir, HgVcs vcs, Disposable parentDisposable) {
        super(vcs.getProject(), rootDir, parentDisposable);
        this.myHgDir = rootDir.findChild(".hg");
        assert (this.myHgDir != null) : ".hg directory wasn't found under " + rootDir.getPresentableUrl();
        this.myReader = new HgRepositoryReader(vcs, VfsUtilCore.virtualToIoFile((VirtualFile)this.myHgDir));
        this.myConfig = HgConfig.getInstance(this.getProject(), rootDir);
        this.update();
    }

    public static HgRepository getInstance(VirtualFile root, Project project, Disposable parentDisposable) {
        HgVcs vcs = HgVcs.getInstance(project);
        if (vcs == null) {
            throw new IllegalArgumentException("Vcs not found for project " + project);
        }
        HgRepositoryImpl repository = new HgRepositoryImpl(root, vcs, parentDisposable);
        repository.setupUpdater();
        return repository;
    }

    private void setupUpdater() {
        HgRepositoryUpdater updater = new HgRepositoryUpdater(this);
        Disposer.register((Disposable)this, (Disposable)updater);
    }

    @Override
    public VirtualFile getHgDir() {
        return this.myHgDir;
    }

    public Repository.State getState() {
        return this.myInfo.getState();
    }

    public String getCurrentBranchName() {
        String branchOrBookMarkName = this.getCurrentBookmark();
        if (StringUtil.isEmptyOrSpaces((String)branchOrBookMarkName)) {
            branchOrBookMarkName = this.getCurrentBranch();
        }
        return branchOrBookMarkName;
    }

    public AbstractVcs getVcs() {
        return HgVcs.getInstance(this.getProject());
    }

    @Override
    public String getCurrentBranch() {
        return this.myInfo.getCurrentBranch();
    }

    public String getCurrentRevision() {
        return this.myInfo.getCurrentRevision();
    }

    @Override
    public String getTipRevision() {
        return this.myInfo.getTipRevision();
    }

    @Override
    public Map<String, Set<Hash>> getBranches() {
        return this.myInfo.getBranches();
    }

    @Override
    public Set<String> getOpenedBranches() {
        return this.myOpenedBranches;
    }

    @Override
    public Collection<HgNameWithHashInfo> getBookmarks() {
        return this.myInfo.getBookmarks();
    }

    @Override
    public String getCurrentBookmark() {
        return this.myInfo.getCurrentBookmark();
    }

    @Override
    public Collection<HgNameWithHashInfo> getTags() {
        return this.myInfo.getTags();
    }

    @Override
    public Collection<HgNameWithHashInfo> getLocalTags() {
        return this.myInfo.getLocalTags();
    }

    @Override
    public HgConfig getRepositoryConfig() {
        return this.myConfig;
    }

    @Override
    public boolean hasSubrepos() {
        return this.myInfo.hasSubrepos();
    }

    @Override
    public Collection<HgNameWithHashInfo> getSubrepos() {
        return this.myInfo.getSubrepos();
    }

    public boolean isFresh() {
        return this.myIsFresh;
    }

    public void update() {
        HgRepoInfo currentInfo = this.readRepoInfo();
        final Project project = this.getProject();
        if (!project.isDisposed() && !currentInfo.equals(this.myInfo)) {
            this.myInfo = currentInfo;
            HgCommandResult branchCommandResult = new HgBranchesCommand(project, this.getRoot()).collectBranches();
            if (branchCommandResult == null || branchCommandResult.getExitValue() != 0) {
                LOG.warn("Could not collect hg opened branches.");
                this.myOpenedBranches = this.myInfo.getBranches().keySet();
            } else {
                this.myOpenedBranches = HgBranchesCommand.collectNames(branchCommandResult);
            }
            ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

                @Override
                public void run() {
                    if (!project.isDisposed()) {
                        ((HgUpdater)project.getMessageBus().syncPublisher(HgVcs.STATUS_TOPIC)).update(project, HgRepositoryImpl.this.getRoot());
                    }
                }
            });
        }
    }

    public String toLogString() {
        return String.format("HgRepository " + this.getRoot() + " : " + this.myInfo, new Object[0]);
    }

    private HgRepoInfo readRepoInfo() {
        this.myIsFresh = this.myIsFresh && this.myReader.isFresh();
        return new HgRepoInfo(this.myReader.readCurrentBranch(), this.myReader.readCurrentRevision(), this.myReader.readCurrentTipRevision(), this.myReader.readState(), this.myReader.readBranches(), this.myReader.readBookmarks(), this.myReader.readCurrentBookmark(), this.myReader.readTags(), this.myReader.readLocalTags(), this.myReader.readSubrepos());
    }

    @Override
    public void updateConfig() {
        this.myConfig = HgConfig.getInstance(this.getProject(), this.getRoot());
    }
}

