/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.repo;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.repo.RepoStateException;
import com.intellij.dvcs.repo.Repository;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLogObjectsFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.binary.Hex;
import org.zmlx.hg4idea.HgNameWithHashInfo;
import org.zmlx.hg4idea.HgVcs;
import org.zmlx.hg4idea.util.HgVersion;

public class HgRepositoryReader {
    private static final Logger LOG = Logger.getInstance(HgRepositoryReader.class);
    private static Pattern HASH_NAME = Pattern.compile("\\s*([0-9a-fA-F]+)\\s+(.+)");
    private static Pattern HASH_STATUS_NAME = Pattern.compile("\\s*([0-9a-fA-F]+)\\s+\\w\\s+(.+)");
    private final File myHgDir;
    private File myBranchHeadsFile;
    private final File myCacheDir;
    private final File myCurrentBranch;
    private final File myBookmarksFile;
    private final File myCurrentBookmark;
    private final File myTagsFile;
    private final File myLocalTagsFile;
    private final File myDirStateFile;
    private final File mySubrepoFile;
    private final VcsLogObjectsFactory myVcsObjectsFactory;
    private final boolean myStatusInBranchFile;
    final HgVcs myVcs;

    public HgRepositoryReader(HgVcs vcs, File hgDir) {
        this.myHgDir = hgDir;
        DvcsUtil.assertFileExists((File)this.myHgDir, (String)(".hg directory not found in " + this.myHgDir));
        this.myVcs = vcs;
        HgVersion version = this.myVcs.getVersion();
        this.myStatusInBranchFile = version.hasBranch2();
        this.myCacheDir = new File(this.myHgDir, "cache");
        this.myBranchHeadsFile = HgRepositoryReader.identifyBranchHeadFile(version, this.myCacheDir);
        this.myCurrentBranch = new File(this.myHgDir, "branch");
        this.myBookmarksFile = new File(this.myHgDir, "bookmarks");
        this.myCurrentBookmark = new File(this.myHgDir, "bookmarks.current");
        this.myLocalTagsFile = new File(this.myHgDir, "localtags");
        this.myTagsFile = new File(this.myHgDir.getParentFile(), ".hgtags");
        this.mySubrepoFile = new File(this.myHgDir.getParentFile(), ".hgsubstate");
        this.myDirStateFile = new File(this.myHgDir, "dirstate");
        this.myVcsObjectsFactory = (VcsLogObjectsFactory)ServiceManager.getService((Project)vcs.getProject(), VcsLogObjectsFactory.class);
    }

    private static File identifyBranchHeadFile(HgVersion version, File parentCacheFile) {
        if (version.hasBranch2()) {
            File file = new File(parentCacheFile, "branch2-served");
            return file.exists() ? file : new File(parentCacheFile, "branch2-base");
        }
        if (version.hasBranchHeadsBaseServed()) {
            File file = new File(parentCacheFile, "branchheads-served");
            return file.exists() ? file : new File(parentCacheFile, "branchheads-base");
        }
        return new File(parentCacheFile, "branchheads");
    }

    public String readCurrentRevision() {
        if (!this.isDirStateInfoAvailable()) {
            return null;
        }
        try {
            return Hex.encodeHexString((byte[])this.readBytesFromFile(this.myDirStateFile, 20));
        }
        catch (IOException e) {
            LOG.error("IOException while trying to read current repository state information.", (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] readBytesFromFile(File file, int len) throws IOException {
        byte[] bytes;
        FileInputStream stream = new FileInputStream(file);
        try {
            bytes = FileUtil.loadBytes((InputStream)stream, (int)len);
        }
        finally {
            ((InputStream)stream).close();
        }
        return bytes;
    }

    public String readCurrentTipRevision() {
        String[] branchesWithHeads;
        if (!this.isBranchInfoAvailable()) {
            return null;
        }
        try {
            branchesWithHeads = DvcsUtil.tryLoadFile((File)this.myBranchHeadsFile).split("\n");
        }
        catch (RepoStateException e) {
            LOG.error((Throwable)e);
            return null;
        }
        String head = branchesWithHeads[0];
        Matcher matcher = HASH_NAME.matcher(head);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return null;
    }

    private boolean isBranchInfoAvailable() {
        this.myBranchHeadsFile = HgRepositoryReader.identifyBranchHeadFile(this.myVcs.getVersion(), this.myCacheDir);
        return !this.isFresh() && this.myBranchHeadsFile.exists();
    }

    private boolean isDirStateInfoAvailable() {
        return this.myDirStateFile.exists();
    }

    public String readCurrentBranch() {
        return this.branchExist() ? DvcsUtil.tryLoadFileOrReturn((File)this.myCurrentBranch, (String)"default") : "default";
    }

    public Map<String, Set<Hash>> readBranches() {
        HashMap<String, Set<Hash>> branchesWithHashes = new HashMap<String, Set<Hash>>();
        if (this.isBranchInfoAvailable()) {
            Pattern activeBranchPattern = this.myStatusInBranchFile ? HASH_STATUS_NAME : HASH_NAME;
            String[] branchesWithHeads = DvcsUtil.tryLoadFileOrReturn((File)this.myBranchHeadsFile, (String)"").split("\n");
            for (int i = 1; i < branchesWithHeads.length; ++i) {
                Matcher matcher = activeBranchPattern.matcher(branchesWithHeads[i]);
                if (!matcher.matches()) continue;
                String name = matcher.group(2);
                if (branchesWithHashes.containsKey(name)) {
                    ((Set)branchesWithHashes.get(name)).add(this.myVcsObjectsFactory.createHash(matcher.group(1)));
                    continue;
                }
                HashSet<Hash> hashes = new HashSet<Hash>();
                hashes.add(this.myVcsObjectsFactory.createHash(matcher.group(1)));
                branchesWithHashes.put(name, hashes);
            }
        }
        return branchesWithHashes;
    }

    public boolean isMergeInProgress() {
        return new File(this.myHgDir, "merge").exists();
    }

    public boolean hasSubrepos() {
        return this.mySubrepoFile.exists();
    }

    public boolean isRebaseInProgress() {
        return new File(this.myHgDir, "rebasestate").exists();
    }

    private boolean isCherryPickInProgress() {
        return new File(this.myHgDir, "graftstate").exists();
    }

    public Repository.State readState() {
        if (this.isRebaseInProgress()) {
            return Repository.State.REBASING;
        }
        if (this.isCherryPickInProgress()) {
            return Repository.State.GRAFTING;
        }
        return this.isMergeInProgress() ? Repository.State.MERGING : Repository.State.NORMAL;
    }

    public boolean isFresh() {
        return !this.myCacheDir.exists();
    }

    public boolean branchExist() {
        return this.myCurrentBranch.exists();
    }

    public Collection<HgNameWithHashInfo> readBookmarks() {
        return this.readReference(this.myBookmarksFile);
    }

    public Collection<HgNameWithHashInfo> readTags() {
        return this.readReference(this.myTagsFile);
    }

    public Collection<HgNameWithHashInfo> readLocalTags() {
        return this.readReference(this.myLocalTagsFile);
    }

    private Collection<HgNameWithHashInfo> readReference(File fileWithReferences) {
        String[] namesWithHashes;
        HashSet<HgNameWithHashInfo> refs = new HashSet<HgNameWithHashInfo>();
        if (!fileWithReferences.exists()) {
            return refs;
        }
        for (String str : namesWithHashes = DvcsUtil.tryLoadFileOrReturn((File)fileWithReferences, (String)"").split("\n")) {
            Matcher matcher = HASH_NAME.matcher(str);
            if (!matcher.matches()) continue;
            refs.add(new HgNameWithHashInfo(matcher.group(2), this.myVcsObjectsFactory.createHash(matcher.group(1))));
        }
        return refs;
    }

    public String readCurrentBookmark() {
        return this.myCurrentBookmark.exists() ? DvcsUtil.tryLoadFileOrReturn((File)this.myCurrentBookmark, (String)"") : null;
    }

    public Collection<HgNameWithHashInfo> readSubrepos() {
        if (!this.hasSubrepos()) {
            return Collections.emptySet();
        }
        return this.readReference(this.mySubrepoFile);
    }
}

