/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.status.ui;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.impl.status.EditorBasedWidget;
import com.intellij.util.Consumer;
import com.intellij.util.messages.MessageBusConnection;
import java.awt.event.MouseEvent;
import org.zmlx.hg4idea.HgProjectSettings;
import org.zmlx.hg4idea.HgUpdater;
import org.zmlx.hg4idea.HgVcs;
import org.zmlx.hg4idea.branch.HgBranchPopup;
import org.zmlx.hg4idea.repo.HgRepository;
import org.zmlx.hg4idea.util.HgUtil;

public class HgStatusWidget
extends EditorBasedWidget
implements StatusBarWidget.MultipleTextValuesPresentation,
StatusBarWidget.Multiframe,
HgUpdater {
    private static final String MAX_STRING = "Hg: Merging default ";
    private final HgVcs myVcs;
    private final HgProjectSettings myProjectSettings;
    private volatile String myText = "";
    private volatile String myTooltip = "";

    public HgStatusWidget(HgVcs vcs, Project project, HgProjectSettings projectSettings) {
        super(project);
        this.myVcs = vcs;
        this.myProjectSettings = projectSettings;
    }

    public StatusBarWidget copy() {
        return new HgStatusWidget(this.myVcs, this.getProject(), this.myProjectSettings);
    }

    public String ID() {
        return HgStatusWidget.class.getName();
    }

    public StatusBarWidget.WidgetPresentation getPresentation(StatusBarWidget.PlatformType type) {
        return this;
    }

    public void selectionChanged(FileEditorManagerEvent event) {
        this.update();
    }

    public void fileOpened(FileEditorManager source, VirtualFile file) {
        this.update();
    }

    public void fileClosed(FileEditorManager source, VirtualFile file) {
        this.update();
    }

    public ListPopup getPopupStep() {
        Project project = this.getProject();
        if (project == null || project.isDisposed()) {
            return null;
        }
        VirtualFile root = HgUtil.getRootForSelectedFile(project);
        HgRepository repository = (HgRepository)HgUtil.getRepositoryManager(project).getRepositoryForRoot(root);
        if (repository != null) {
            return HgBranchPopup.getInstance(project, repository).asListPopup();
        }
        return null;
    }

    public String getSelectedValue() {
        String text = this.myText;
        return StringUtil.isEmpty((String)text) ? "" : "hg: " + text;
    }

    @Deprecated
    public String getMaxValue() {
        return MAX_STRING;
    }

    public String getTooltipText() {
        return this.myTooltip;
    }

    public Consumer<MouseEvent> getClickConsumer() {
        return new Consumer<MouseEvent>(){

            public void consume(MouseEvent mouseEvent) {
                HgStatusWidget.this.update();
            }
        };
    }

    @Override
    public void update(Project project, VirtualFile root) {
        this.updateLater();
    }

    private void updateLater() {
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                HgStatusWidget.this.update();
            }
        });
    }

    private void update() {
        Project project = this.getProject();
        if (project == null || project.isDisposed()) {
            this.emptyTextAndTooltip();
            return;
        }
        HgRepository repo = HgUtil.getCurrentRepository(project);
        if (repo == null) {
            this.emptyTextAndTooltip();
            return;
        }
        this.myTooltip = HgUtil.getDisplayableBranchOrBookmarkText(repo);
        this.myText = StringUtil.shortenTextWithEllipsis((String)this.myTooltip, (int)MAX_STRING.length(), (int)5);
        if (!this.isDisposed() && this.myStatusBar != null) {
            this.myStatusBar.updateWidget(this.ID());
        }
    }

    public void activate() {
        Project project = this.getProject();
        if (null == project) {
            return;
        }
        MessageBusConnection busConnection = project.getMessageBus().connect();
        busConnection.subscribe(HgVcs.STATUS_TOPIC, (Object)this);
        DvcsUtil.installStatusBarWidget((Project)this.myProject, (StatusBarWidget)this);
        this.updateLater();
    }

    public void deactivate() {
        if (this.isDisposed()) {
            return;
        }
        DvcsUtil.removeStatusBarWidget((Project)this.myProject, (StatusBarWidget)this);
    }

    public void dispose() {
        this.deactivate();
        super.dispose();
    }

    private void emptyTextAndTooltip() {
        this.myText = "";
        this.myTooltip = "";
    }
}

