/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.util;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.event.HyperlinkEvent;
import org.zmlx.hg4idea.action.HgCommandResultNotifier;
import org.zmlx.hg4idea.execution.HgCommandResult;
import org.zmlx.hg4idea.util.HgUtil;

public final class HgErrorUtil {
    private static final Logger LOG = Logger.getInstance((String)HgErrorUtil.class.getName());
    private static final String SETTINGS_LINK = "settings";
    public static final String MAPPING_ERROR_MESSAGE = "Please, ensure that your project base dir is hg root directory or specify full repository path in  <a href='settings'>directory mappings panel</a>.";
    private static final String MERGE_WITH_ANCESTOR_ERROR = "merging with a working directory ancestor has no effect";

    private HgErrorUtil() {
    }

    public static boolean isAbort(HgCommandResult result) {
        return result == null || HgErrorUtil.getAbortLine(result) != null;
    }

    private static String getAbortLine(HgCommandResult result) {
        List<String> errorLines = result.getErrorLines();
        return (String)ContainerUtil.find(errorLines, (Condition)new Condition<String>(){

            public boolean value(String s) {
                return HgErrorUtil.isAbortLine(s);
            }
        });
    }

    public static boolean isAncestorMergeError(HgCommandResult result) {
        if (result == null) {
            return false;
        }
        String errorLine = HgErrorUtil.getAbortLine(result);
        return errorLine != null && StringUtil.contains((CharSequence)errorLine, (CharSequence)MERGE_WITH_ANCESTOR_ERROR);
    }

    public static boolean isAuthorizationError(HgCommandResult result) {
        if (result == null) {
            return false;
        }
        String line = HgErrorUtil.getLastErrorLine(result);
        return HgErrorUtil.isAuthorizationError(line);
    }

    private static String getLastErrorLine(HgCommandResult result) {
        if (result == null) {
            return null;
        }
        List<String> errorLines = result.getErrorLines();
        if (errorLines.isEmpty()) {
            return null;
        }
        return errorLines.get(errorLines.size() - 1);
    }

    public static boolean hasErrorsInCommandExecution(HgCommandResult result) {
        return HgErrorUtil.isAbort(result) || result.getExitValue() != 0;
    }

    public static boolean isCommandExecutionFailed(HgCommandResult result) {
        return HgErrorUtil.isAbort(result) || result.getExitValue() > 1;
    }

    public static boolean hasAuthorizationInDestinationPath(String destinationPath) {
        if (StringUtil.isEmptyOrSpaces((String)destinationPath)) {
            return false;
        }
        return HgUtil.URL_WITH_PASSWORD.matcher(destinationPath).matches();
    }

    public static NotificationListener getMappingErrorNotificationListener(final Project project) {
        return new NotificationListener.Adapter(){

            protected void hyperlinkActivated(Notification notification, HyperlinkEvent e) {
                if (HgErrorUtil.SETTINGS_LINK.equals(e.getDescription())) {
                    ShowSettingsUtil.getInstance().showSettingsDialog(project, VcsBundle.message((String)"version.control.main.configurable.name", (Object[])new Object[0]));
                }
            }
        };
    }

    public static boolean isUnknownEncodingError(HgCommandResult result) {
        if (result == null) {
            return false;
        }
        List<String> errorLines = result.getErrorLines();
        if (errorLines.isEmpty()) {
            return false;
        }
        String line = errorLines.get(0);
        return !StringUtil.isEmptyOrSpaces((String)line) && line.contains("abort") && line.contains("unknown encoding");
    }

    public static boolean hasUncommittedChangesConflict(HgCommandResult result) {
        if (result == null) {
            return false;
        }
        Pattern UNCOMMITTED_PATTERN = Pattern.compile(".*abort.*uncommitted\\s*(change|merge).*", 32);
        Matcher matcher = UNCOMMITTED_PATTERN.matcher(result.getRawError());
        return matcher.matches();
    }

    public static boolean isAuthorizationError(String line) {
        return !StringUtil.isEmptyOrSpaces((String)line) && (line.contains("authorization required") || line.contains("authorization failed"));
    }

    public static boolean isAbortLine(String line) {
        return !StringUtil.isEmptyOrSpaces((String)line) && line.trim().startsWith("abort:");
    }

    public static void handleException(Project project, Exception e) {
        HgErrorUtil.handleException(project, "Error", e);
    }

    public static void handleException(Project project, String title, Exception e) {
        LOG.info((Throwable)e);
        new HgCommandResultNotifier(project).notifyError(null, title, e.getMessage());
    }

    public static void markDirtyAndHandleErrors(Project project, VirtualFile repository) {
        try {
            HgUtil.markDirectoryDirty(project, repository);
        }
        catch (InvocationTargetException e) {
            HgErrorUtil.handleException(project, e);
        }
        catch (InterruptedException e) {
            HgErrorUtil.handleException(project, e);
        }
    }
}

